% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFMImage.R
\name{importFromNanoscope}
\alias{importFromNanoscope}
\title{Import data from nanoscope analysis(tm) tool}
\usage{
importFromNanoscope(fullfilename)
}
\arguments{
\item{fullfilename}{a concatenated string of the directory and filename exported with Nanoscope analysis(TM) software}
}
\description{
The imported file should contain a header and list of heights
The header should contain the following fields:
\itemize{
  \item Lines: number of scanned lines (e.g. 512)
  \item Sampsline: number of scan per line (e.g. 512)
  \item ScanSize: the sample size (e.g. 1000nm) the extension nm is mandatory and will be removed
}
}
\details{
\code{importFromNanoscope} returns an \code{\link{AFMImage}}
}
\examples{
\dontrun{
library(AFM)

fullfilename<-"/user/ubuntu/NanoscopeFlattenExportedFile.txt"
myAFMimage<-importFromNanoscope(fullfilename)
displayIn3D(myAFMimage, width=1024, noLight=TRUE))
}
}
\author{
M.Beauvais
}
