% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ARPA_Lombardia_W_data.R
\name{get_ARPA_Lombardia_W_data}
\alias{get_ARPA_Lombardia_W_data}
\title{Download weather/meteorological data from ARPA Lombardia website}
\usage{
get_ARPA_Lombardia_W_data(
  ID_station = NULL,
  Date_begin = "2021-01-01",
  Date_end = "2022-12-31",
  Frequency = "10mins",
  Var_vec = NULL,
  Fns_vec = NULL,
  by_sensor = FALSE,
  verbose = TRUE,
  parallel = FALSE,
  parworkers = NULL,
  parfuturetype = "multisession"
)
}
\arguments{
\item{ID_station}{Numeric value. ID of the station to consider. Using ID_station = NULL, all the available
stations are selected. Default is ID_station = NULL.}

\item{Date_begin}{Character vector of the first date-time to download. Format can be either "YYYY-MM-DD" or "YYYY-MM-DD hh:mm:ss". Default is Date_begin = "2022-01-01".}

\item{Date_end}{Character vector of the last date-time to download. Format can be either "YYYY-MM-DD" or "YYYY-MM-DD hh:mm:ss". Default is Date_end = "2022-12-31".}

\item{Frequency}{Temporal aggregation frequency. It can be "10mins", "hourly", "daily", "weekly",
"monthly". Default is Frequency = "10mins"}

\item{Var_vec}{Character vector of variables to aggregate. If NULL (default) all the variables are averaged,
except for 'Temperature' and 'Snow_height', which are cumulated.}

\item{Fns_vec}{Character vector of aggregation function to apply to the selected variables.
Available functions are mean, median, min, max, sum, qPP (PP-th percentile), sd, var,
vc (variability coefficient), skew (skewness) and kurt (kurtosis). Attention: for Wind Speed and
Wind Speed Gust only mean, min and max are available; for Wind Direction and Wind Direction Gust
only mean is available.}

\item{by_sensor}{Logic value (TRUE or FALSE). If 'by_sensor = TRUE', the function returns the observed concentrations
by sensor code, while if 'by_sensor = FALSE' (default) it returns the observed concentrations by station.}

\item{verbose}{Logic value (TRUE or FALSE). Toggle warnings and messages. If 'verbose = TRUE' (default) the function
prints on the screen some messages describing the progress of the tasks. If 'verbose = FALSE' any message about
the progression is suppressed.}

\item{parallel}{Logic value (TRUE or FALSE). If 'parallel = FALSE' (default), data downloading is performed using a sequential/serial approach and additional parameters 'parworkers' and 'parfuturetype' are ignored.
When 'parallel = TRUE', data downloading is performed using parallel computing through the Futureverse setting.
More detailed information about parallel computing in the Futureverse can be found at the following webpages:
https://future.futureverse.org/ and https://cran.r-project.org/web/packages/future.apply/vignettes/future.apply-1-overview.html}

\item{parworkers}{Numeric integer value. If 'parallel = TRUE' (parallel mode active), the user can declare the number of parallel workers to be activated using 'parworkers = integer number'. By default ('parworkers = NULL'), the number of active workers is half of the available local cores.}

\item{parfuturetype}{Character vector. If 'parallel = TRUE' (parallel mode active), the user can declare the parallel strategy to be used according to the Futureverse syntax through 'parfuturetype'. By default, the 'multisession' (background R sessions on local machine) is used. In alternative, the 'multicore' (forked R processes on local machine. Not supported by Windows and RStudio) setting can be used.}
}
\value{
A data frame of class 'data.frame' and 'ARPALdf'. The object is fully compatible with Tidyverse.
}
\description{
'get_ARPA_Lombardia_W_data' returns observed air weather measurements collected by
ARPA Lombardia ground detection system for Lombardy region in Northern Italy.
Available meteorological variables are: temperature (Celsius degrees), rainfall (mm), wind speed (m/s),
wind direction (degrees), relative humidity (%), global solar radiation (W/m2), and snow height (cm).
Data are available from 1989 and are updated up to the current date.
For more information about the municipal data visit the section 'Monitoraggio aria' at the webpage:
https://www.dati.lombardia.it/stories/s/auv9-c2sj
}
\details{
More detailed description.
}
\examples{
\donttest{
## Download all the (10 minutes frequency) weather measurements at station 100
## between August 2021 and December 2022.
if (require("RSocrata")) {
    get_ARPA_Lombardia_W_data(ID_station = 100, Date_begin = "2021-08-01",
          Date_end = "2022-12-31", Frequency = "10mins")
}
## Download all the (daily frequency) weather measurements at station 1974 during 2022
if (require("RSocrata")) {
    get_ARPA_Lombardia_W_data(ID_station = 1974, Date_begin = "2023-01-01",
          Date_end = "2023-12-31", Frequency = "daily")
}
}

}
