% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probe_eff.R
\name{probe_eff}
\alias{probe_eff}
\title{Probe efficiency}
\usage{
probe_eff(df, params, orient = "u", method = "blunt pipe")
}
\arguments{
\item{df}{is the particle data set (data frame) established with the
`particle_dist` function}

\item{params}{is the parameter data set for parameters that are not
particle size-dependent}

\item{orient}{orientation of the probe. Options are 'u' for up,
'd' for down, and 'h' for horizontal}

\item{method}{is the model for the probe efficiency. Default is
'blunt pipe', based on Su WC and Vincent JH, Towards a general
semi-empirical model for the aspiration efficiencies of aerosol samplers
in perfectly calm air, Aerosol Science 35 (2004) 1119-1134}
}
\value{
data frame containing original particle distribution with added
data for this element
}
\description{
In order to run this function, first produce a particle distribution
with the `particle_dist` function, then produce a parameter set with
the `set_params` function. Both of these results must be stored as
per examples described in the help set with each.
}
\examples{
df <- particle_dist() # set up particle distribution
params <- set_params_1("D_tube" = 2.54, "Q_lpm" = 100,
"T_C" = 25, "P_kPa" = 101.325) #example system parameters
df <- set_params_2(df, params) #particle size-dependent parameters
df <- probe_eff(df, params, orient = 'u') #probe orientation - draws upward
head(df)
}
