% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert-pgs-to-bed.R
\name{combine.pgs.bed}
\alias{combine.pgs.bed}
\title{Combine PGS BED files}
\usage{
combine.pgs.bed(
  pgs.bed.list,
  add.annotation.data = FALSE,
  annotation.column.index = 4,
  slop = 0
)
}
\arguments{
\item{pgs.bed.list}{A named list of data.frames containing PGS coordinates in BED format.}

\item{add.annotation.data}{A logical indicating whether an additional annotation data column should be added to the annotation column.}

\item{annotation.column.index}{An integer indicating the index of the column in the data frames in \code{pgs.bed.list} that should be added to the annotation column.}

\item{slop}{An integer indicating the number of base pairs to add to the BED interval on either side.}
}
\value{
A data.frame containing the merged PGS coordinates in BED format with an extra annotation column containing the name of the PGS and data from one additional column optionally selected by the user.
}
\description{
Merge overlapping PGS coordinates in multiple BED files.
}
\examples{
bed1 <- data.frame(
    chr = c(1, 2, 3),
    start = c(1, 2, 3),
    end = c(2, 3, 4),
    annotation = c('a', 'b', 'c')
    );
bed2 <- data.frame(
    chr = c(1, 2, 3),
    start = c(1, 20, 30),
    end = c(2, 21, 31),
    annotation = c('d', 'e', 'f')
    );
bed.input <- list(bed1 = bed1, bed2 = bed2);
combine.pgs.bed(bed.input);
}
