#' Sample Infant Dataset (CSV)
#'
#' A simulated dataset included with the AssumpSure package and used by the Shiny app
#' for demonstration and testing.
#'
#' The file is stored in `inst/extdata/infants.csv` and can be accessed with:
#' `system.file("extdata", "infants.csv", package = "AssumpSure")`.
#'
#' All values are synthetic, created only for demonstration; no human data were used,
#' and no ethical approval or consent is required.
#'
#' @format A CSV file with 251 rows and 12 columns:
#' \describe{
#'   \item{infant_id}{Participant identifier.}
#'   \item{Treatment}{Treatment group.}
#'   \item{timepoint}{Measurement time point.}
#'   \item{gender}{Participant gender.}
#'   \item{born_method}{Method of delivery.}
#'   \item{country}{Participant country.}
#'   \item{fortified}{Whether the participant received fortification.}
#'   \item{nutrients}{Whether the participant received nutrients.}
#'   \item{diarrhea}{Whether the participant experienced diarrhea.}
#'   \item{weight}{Participant weight.}
#'   \item{count}{Bacterial richness count.}
#'   \item{height}{Participant height.}
#' }
#'
#' @source Simulated data generated by the author.
#'
#' @examples
#' read.csv(system.file("extdata", "infants.csv", package = "AssumpSure"))
#' @name infants
NULL
