% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoScore_Survival.R
\name{AutoScore_testing_Survival}
\alias{AutoScore_testing_Survival}
\title{AutoScore STEP(v) for survival outcomes: Evaluate the final score with
  ROC analysis (AutoScore Module 6)}
\usage{
AutoScore_testing_Survival(
  test_set,
  final_variables,
  cut_vec,
  scoring_table,
  threshold = "best",
  with_label = TRUE,
  time_point = c(1, 3, 7, 14, 30, 60, 90)
)
}
\arguments{
\item{test_set}{A processed \code{data.frame} that contains data for testing purpose. This \code{data.frame} should have same format as
\code{train_set} (same variable names and outcomes)}

\item{final_variables}{A vector containing the list of selected variables, selected from Step(ii) \code{\link{AutoScore_parsimony}}. Run \code{vignette("Guide_book", package = "AutoScore")} to see the guidebook or vignette.}

\item{cut_vec}{Generated from STEP(iii)
\code{AutoScore_weighting_Survival()}.Please follow the guidebook}

\item{scoring_table}{The final scoring table after fine-tuning, generated from STEP(iv) \code{\link{AutoScore_fine_tuning}}.Please follow the guidebook}

\item{threshold}{Score threshold for the ROC analysis to generate sensitivity, specificity, etc. If set to "best", the optimal threshold will be calculated (Default:"best").}

\item{with_label}{Set to TRUE if there are labels(`label_time` and `label_status`) in the test_set and
performance will be evaluated accordingly (Default:TRUE).}

\item{time_point}{The time points to be evaluated using time-dependent AUC(t).}
}
\value{
A data frame with predicted score and the outcome for downstream visualization.
}
\description{
AutoScore STEP(v) for survival outcomes: Evaluate the final score with
  ROC analysis (AutoScore Module 6)
}
\examples{
## Please see the guidebook or vignettes
}
\references{
\itemize{
 \item{Xie F, Ning Y, Yuan H, et al. AutoScore-Survival: Developing
 interpretable machine learning-based time-to-event scores with right-censored
 survival data. J Biomed Inform. 2022;125:103959. doi:10.1016/j.jbi.2021.103959}
}
}
\seealso{
\code{\link{AutoScore_rank_Survival}},
  \code{\link{AutoScore_parsimony_Survival}},
  \code{\link{AutoScore_weighting_Survival}},
  \code{\link{AutoScore_fine_tuning_Survival}}.
}
