% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_BEND.R
\name{plot_BEND}
\alias{plot_BEND}
\title{Plot a BEND Model (PREM, CREM, BPREM)}
\usage{
plot_BEND(
  data,
  id_var,
  time_var,
  y_var,
  y2_var = NULL,
  results = NULL,
  xlab = "X",
  ylab = "Y",
  colors = NULL,
  mean_colors = NULL,
  legend_pos = "topright",
  ...
)
}
\arguments{
\item{data}{Data frame in long format, where each row describes a measurement occasion for a given individual. It is assumed that each individual has the same number of assigned timepoints (a.k.a., rows).}

\item{id_var}{Name of column that contains ids for individuals with repeated measures in a longitudinal dataset.}

\item{time_var}{Name of column that contains the time variable.}

\item{y_var}{Name of column that contains the outcome variable.}

\item{y2_var}{(for \code{BPREM} only) Name of column that contains the second outcome variable.}

\item{results}{The output of \code{BEND} model to the data. If results=NULL, only a spaghetti plot of the data will be generated.}

\item{xlab}{X-axis label for the generated plot.}

\item{ylab}{Y-axis label for the generated plot.}

\item{colors}{Colors for each class (\code{PREMM} or \code{CI-PREMM}) or outcome (\code{BPREM}). By default, up to 5 colors are provided in the following order: “blue” (class 1 and outcome 1), “red” (class 2 and outcome 2), “green” (class 3), “gold” (class 4), “gray” (class 5).}

\item{mean_colors}{Colors for the trajectory defined by the mean parameters for each class (\code{PREMM} or \code{CI-PREMM}) or outcome (\code{BPREM}). By default, up to 5 colors are provided in the following order: “darkblue” (class 1 and outcome 1), “darkred” (class 2 and outcome 2), “darkgreen” (class 3), “gold4” (class 4), “darkgray” (class 5).}

\item{legend_pos}{(optional) Option to change legend position (default = "topright").}

\item{...}{(optional) Other parameters to pass to the \code{plot()} function.}
}
\value{
No return value, called to generate plot.
}
\description{
Generates a "spaghetti plot" of observed longitudinal trajectories for each individual. If the results from a \code{BEND} function are supplied, the trajectory defined by the mean parameters is shown in bold. If fitting a mixture (\code{PREMM} or \code{CI-PREMM}) or bivariate model (\code{BPREM}), the mean trajectories for classes or outcomes will be distinguished by color.
}
\examples{
# load simulated data
data(SimData_PREM)
# plot observed data
plot_BEND(data = SimData_PREM,
          id_var = "id",
          time_var = "time",
          y_var = "y")
# load fitted model results
data(results_prem)
# plot fitted results
plot_BEND(data = SimData_PREM,
          id_var = "id",
          time_var = "time",
          y_var = "y",
          results = results_prem)

}
\author{
Corissa T. Rohloff
}
