/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree;

import dr.evolution.tree.RankedNode;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public interface RankedForest {
    public List<RankedNode> getNodes();

    public int getSize();

    public int rank();

    public boolean compatibleRank(List<BitSet> var1);

    public Set<BitSet> clades();

    public int constraintsSatisfied();

    public boolean isClear();

    public static class Parent
    implements RankedForest {
        RankedForest child;
        RankedNode parent;
        List<RankedNode> nodes;
        HashSet<BitSet> clades;
        int constraintsSatisfied = 0;
        boolean clear;

        public Parent(RankedForest rankedForest, RankedNode rankedNode, List<BitSet> list) {
            this.child = rankedForest;
            this.parent = rankedNode;
            this.nodes = new ArrayList<RankedNode>();
            this.nodes.add(rankedNode);
            this.nodes.addAll(rankedForest.getNodes());
            this.nodes.remove(rankedNode.child1);
            this.nodes.remove(rankedNode.child2);
            this.clades = new HashSet();
            this.clades.addAll(rankedForest.clades());
            this.clades.add(rankedNode.cladeBits);
            if (!this.clear) {
                this.constraintsSatisfied = rankedForest.constraintsSatisfied();
                if (list.contains(rankedNode.cladeBits)) {
                    ++this.constraintsSatisfied;
                }
                this.clear = this.constraintsSatisfied == list.size();
            }
        }

        @Override
        public List<RankedNode> getNodes() {
            return this.nodes;
        }

        @Override
        public int getSize() {
            return this.nodes.get((int)0).n;
        }

        @Override
        public int rank() {
            return this.nodes.get((int)0).rank;
        }

        @Override
        public boolean compatibleRank(List<BitSet> list) {
            if (list.size() == 1) {
                return true;
            }
            int n = 0;
            for (BitSet bitSet : list) {
                int n2 = this.getRank(bitSet);
                if (n2 < n) {
                    return false;
                }
                n = n2;
            }
            if (n != Integer.MAX_VALUE) {
                this.clear = true;
            }
            return true;
        }

        @Override
        public Set<BitSet> clades() {
            return this.clades;
        }

        @Override
        public int constraintsSatisfied() {
            return this.constraintsSatisfied;
        }

        @Override
        public boolean isClear() {
            return this.clear;
        }

        private int getRank(BitSet bitSet) {
            if (this.parent.cladeBits.equals(bitSet)) {
                return this.parent.rank;
            }
            if (this.child instanceof Parent) {
                return ((Parent)this.child).getRank(bitSet);
            }
            return Integer.MAX_VALUE;
        }
    }

    public static class Default
    implements RankedForest {
        List<RankedNode> nodes;
        boolean clear;

        public Default(int n, boolean bl) {
            this.nodes = new ArrayList<RankedNode>(n);
            for (int i = n - 1; i >= 0; --i) {
                this.nodes.add(new RankedNode(i, n));
            }
            this.clear = bl;
        }

        @Override
        public int getSize() {
            return this.nodes.get((int)0).n;
        }

        @Override
        public int rank() {
            return this.nodes.get((int)0).rank;
        }

        @Override
        public boolean compatibleRank(List<BitSet> list) {
            return true;
        }

        @Override
        public Set<BitSet> clades() {
            return Collections.emptySet();
        }

        @Override
        public int constraintsSatisfied() {
            return 0;
        }

        @Override
        public boolean isClear() {
            return this.clear;
        }

        @Override
        public List<RankedNode> getNodes() {
            return this.nodes;
        }
    }
}

