/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.speciation;

public class CalibrationLineagesIterator {
    final int[][] taxaPartialOrder;
    final int[] cladesFreeLins;
    private final LinsIterator[] iters;
    private int nCurIters;
    private int[][] vals;
    private int nFreeLineages;
    private final int[] maximalClades;

    /*
     * WARNING - void declaration
     */
    CalibrationLineagesIterator(int[][] nArray, int[][] nArray2, boolean[] blArray, int n) {
        void var6_9;
        int n2;
        this.cladesFreeLins = new int[nArray.length];
        for (n2 = 0; n2 < this.cladesFreeLins.length; ++n2) {
            this.cladesFreeLins[n2] = nArray[n2].length;
            for (int n3 : nArray2[n2]) {
                int n4 = n2;
                this.cladesFreeLins[n4] = this.cladesFreeLins[n4] - nArray[n3].length;
            }
            assert (this.cladesFreeLins[n2] >= 0);
        }
        this.taxaPartialOrder = nArray2;
        this.iters = new LinsIterator[nArray.length + 1];
        this.vals = new int[this.iters.length][];
        n2 = 0;
        for (int n3 : blArray) {
            n2 += n3 != 0 ? 1 : 0;
        }
        this.maximalClades = new int[n2];
        this.nFreeLineages = n;
        n2 = 0;
        boolean bl = false;
        while (var6_9 < blArray.length) {
            if (blArray[var6_9]) {
                this.maximalClades[n2] = var6_9;
                ++n2;
                this.nFreeLineages -= nArray[var6_9].length;
            }
            ++var6_9;
        }
        assert (this.nFreeLineages >= 0);
    }

    int setup(int[] nArray) {
        int n;
        int n2 = this.cladesFreeLins.length;
        this.nCurIters = 0;
        for (n = 0; n < n2; ++n) {
            this.setOneIterator(nArray, this.taxaPartialOrder[n], this.cladesFreeLins[n], nArray[n]);
        }
        if (this.nFreeLineages > 0) {
            this.setOneIterator(nArray, this.maximalClades, this.nFreeLineages, n2 + 1);
        }
        for (n = 0; n < this.nCurIters - 1; ++n) {
            this.vals[n] = this.iters[n].next();
        }
        return this.nCurIters;
    }

    private void setOneIterator(int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = nArray2.length;
        LinsIterator linsIterator = null;
        if (n3 == 0) {
            linsIterator = new LinsIterator(n, n2, null);
        } else {
            int[] nArray3 = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray3[i] = nArray[nArray2[i]];
            }
            linsIterator = new LinsIterator(n, n2, nArray3);
        }
        if (linsIterator != null) {
            this.iters[((LinsIterator)linsIterator).rank - 1] = linsIterator;
            linsIterator.startIter();
            ++this.nCurIters;
        }
    }

    int[][] next() {
        int n;
        int[] nArray = this.iters[this.nCurIters - 1].next();
        if (nArray != null) {
            this.vals[this.nCurIters - 1] = nArray;
            return this.vals;
        }
        for (n = this.nCurIters - 2; n >= 0 && (this.vals[n] = this.iters[n].next()) == null; --n) {
        }
        if (n < 0) {
            return null;
        }
        ++n;
        while (n < this.nCurIters) {
            this.iters[n].startIter();
            this.vals[n] = this.iters[n].next();
            ++n;
        }
        return this.vals;
    }

    public int[][] allJoiners() {
        int[][] nArrayArray = new int[this.nCurIters][];
        for (int i = 0; i < this.nCurIters; ++i) {
            nArrayArray[i] = this.iters[i].ljoins();
        }
        return nArrayArray;
    }

    public int nStart(int n) {
        return this.iters[n].nStart;
    }

    class LinsIterator {
        private final int rank;
        private final int nStart;
        private final int[] joiners;
        private final int[] aStart;
        private final int[] lins;
        private int lastJoinger;
        private boolean stopIter;

        LinsIterator(int n, int n2, int[] nArray) {
            int n3;
            int n4;
            this.rank = n2;
            this.nStart = n;
            this.joiners = new int[n2];
            this.lastJoinger = -1;
            this.aStart = new int[2 + this.rank - 1];
            this.lins = new int[2 + this.rank - 1];
            for (n4 = 0; n4 < this.rank; ++n4) {
                this.joiners[n4] = 0;
            }
            if (nArray != null) {
                int[] nArray2 = nArray;
                n3 = nArray2.length;
                for (int i = 0; i < n3; ++i) {
                    int n5 = nArray2[i];
                    this.joiners[n5] = 1;
                    if (this.lastJoinger >= n5) continue;
                    this.lastJoinger = n5;
                }
            }
            this.aStart[0] = n;
            if (this.lastJoinger <= 0) {
                for (n4 = 1; n4 < this.rank + 1; ++n4) {
                    this.aStart[n4] = 2;
                }
                if (this.rank > 1) {
                    int n6 = this.rank - 1;
                    this.aStart[n6] = this.aStart[n6] - 1;
                }
            } else {
                if (this.nStart > 0) {
                    for (n4 = 1; n4 < this.lastJoinger + 1; ++n4) {
                        this.aStart[n4] = 1;
                    }
                    while (n4 < this.rank + 1) {
                        this.aStart[n4] = 2;
                        ++n4;
                    }
                } else {
                    n4 = nArray[0];
                    for (n3 = 0; n3 < nArray.length; ++n3) {
                        n4 = Math.min(n4, nArray[n3]);
                    }
                    for (n3 = 1; n3 < n4 + 1; ++n3) {
                        this.aStart[n3] = 0;
                    }
                    while (n3 < this.lastJoinger + 1) {
                        this.aStart[n3] = 1;
                        ++n3;
                    }
                    while (n3 < this.rank + 1) {
                        this.aStart[n3] = 2;
                        ++n3;
                    }
                }
                int n7 = this.rank - 1;
                this.aStart[n7] = this.aStart[n7] - 1;
            }
        }

        void startIter() {
            for (int i = 0; i < this.rank + 1; ++i) {
                this.lins[i] = this.aStart[i];
            }
            this.stopIter = false;
        }

        final int[] next() {
            int n;
            if (this.lastJoinger <= 0) {
                for (n = this.rank - 1; n >= 1 && this.lins[n] == this.lins[n - 1]; --n) {
                }
                if (n == 0) {
                    if (this.rank == 1 && !this.stopIter) {
                        this.stopIter = true;
                        return this.lins;
                    }
                    return null;
                }
                int n2 = n++;
                this.lins[n2] = this.lins[n2] + 1;
                while (n < this.rank) {
                    this.lins[n] = 2;
                    ++n;
                }
            } else {
                while (n >= 1 && this.lins[n] == this.lins[n - 1] + this.joiners[n - 1]) {
                    --n;
                }
                if (n == 0) {
                    return null;
                }
                int n3 = n++;
                this.lins[n3] = this.lins[n3] + 1;
                while (n < this.rank) {
                    this.lins[n] = n <= this.lastJoinger ? 1 : 2;
                    ++n;
                }
            }
            return this.lins;
        }

        final int[] ljoins() {
            return this.joiners;
        }
    }
}

