/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.characters;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jebl.evolution.characters.Character;
import jebl.evolution.characters.CharacterType;
import jebl.evolution.taxa.Taxon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscreteCharacter
implements Character {
    private boolean isOrdered;
    private String name;
    private String desc;
    private CharacterType charType;
    private Set<Taxon> taxa;
    private Map<Integer, String> stateDesc;
    private int numOfStates;

    public DiscreteCharacter(String name, String desc, int numOfStates) {
        this.name = name;
        this.charType = CharacterType.DISCRETE;
        this.desc = desc;
        this.numOfStates = numOfStates;
        this.taxa = new HashSet<Taxon>();
    }

    public DiscreteCharacter(String name, String desc, int numOfStates, Set<Taxon> taxa) {
        this.name = name;
        this.charType = CharacterType.DISCRETE;
        this.desc = desc;
        this.numOfStates = numOfStates;
        this.taxa = taxa;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setDesc(String desc) {
        this.desc = desc;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    @Override
    public CharacterType getType() {
        return this.charType;
    }

    @Override
    public void addTaxon(Taxon taxon) {
        this.taxa.add(taxon);
    }

    @Override
    public Object getValue(Taxon taxon) {
        int value = (Integer)taxon.getAttribute(this.name);
        return value;
    }

    public boolean isOrdered() {
        return this.isOrdered;
    }

    public void setIsOrdered(boolean isOrdered) {
        this.isOrdered = isOrdered;
    }

    public double getNumOfStates() {
        return this.numOfStates;
    }

    public void setNumOfStates(int numOfStates) {
        this.numOfStates = numOfStates;
    }

    @Override
    public Set<Taxon> getTaxa() {
        return this.taxa;
    }

    public void setStateDesc(Map<Integer, String> stateDesc) {
        this.stateDesc = stateDesc;
    }

    public Map<Integer, String> getStateDesc() {
        return this.stateDesc;
    }

    public String getStateDesc(int state) {
        return this.stateDesc.get(state);
    }
}

