/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.continuous.cdi;

import dr.evomodel.treedatalikelihood.continuous.cdi.CDIException;
import dr.evomodel.treedatalikelihood.continuous.cdi.CDIJNIWrapper;
import dr.evomodel.treedatalikelihood.continuous.cdi.ContinuousDiffusionIntegrator;
import dr.evomodel.treedatalikelihood.continuous.cdi.InstanceDetails;
import dr.evomodel.treedatalikelihood.continuous.cdi.PrecisionType;
import dr.evomodel.treedatalikelihood.continuous.cdi.ResourceDetails;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class CDIFactory {
    private static Map<Integer, ResourceDetails> resourceDetailsMap = new HashMap<Integer, ResourceDetails>();

    public static String getVersionInformation() {
        CDIFactory.getCDIJNIWrapper();
        if (CDIJNIWrapper.INSTANCE != null) {
            try {
                return CDIJNIWrapper.INSTANCE.getCitation();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                return "Using CDI library v0.1 for accelerated, parallel likelihood evaluation";
            }
        }
        return "CDI not installed/found";
    }

    public static String getVersion() {
        CDIFactory.getCDIJNIWrapper();
        if (CDIJNIWrapper.INSTANCE != null) {
            try {
                return CDIJNIWrapper.INSTANCE.getVersion();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                return "0.1";
            }
        }
        return "CDI not installed/found";
    }

    public static List<ResourceDetails> getResourceDetails() {
        CDIFactory.getCDIJNIWrapper();
        return new ArrayList<ResourceDetails>(resourceDetailsMap.values());
    }

    public static ResourceDetails getResourceDetails(int n) {
        CDIFactory.getCDIJNIWrapper();
        return resourceDetailsMap.get(n);
    }

    public static ContinuousDiffusionIntegrator loadCDIInstance(PrecisionType precisionType, int n, int n2, int n3, int n4) {
        boolean bl = Boolean.valueOf(System.getProperty("java.only"));
        if (!bl) {
            CDIFactory.getCDIJNIWrapper();
            if (CDIJNIWrapper.INSTANCE != null) {
                try {
                    ContinuousDiffusionIntegrator continuousDiffusionIntegrator = null;
                    InstanceDetails instanceDetails = continuousDiffusionIntegrator.getDetails();
                    if (instanceDetails != null) {
                        return continuousDiffusionIntegrator;
                    }
                }
                catch (CDIException cDIException) {
                    Logger.getLogger("cdi").info("  " + cDIException.getMessage());
                }
            }
        }
        return new ContinuousDiffusionIntegrator.Basic(precisionType, n, n2, n2, n3, n4);
    }

    private static CDIJNIWrapper getCDIJNIWrapper() {
        if (CDIJNIWrapper.INSTANCE == null) {
            try {
                CDIJNIWrapper.loadCDILibrary();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.err.println("Failed to load CDI library: " + unsatisfiedLinkError.getMessage());
            }
            if (CDIJNIWrapper.INSTANCE != null) {
                for (ResourceDetails resourceDetails : CDIJNIWrapper.INSTANCE.getResourceList()) {
                    resourceDetailsMap.put(resourceDetails.getNumber(), resourceDetails);
                }
            }
        }
        return CDIJNIWrapper.INSTANCE;
    }
}

