% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readtrackData.R
\name{readtrackData}
\alias{readtrackData}
\title{Reads tracking data from a specified file.}
\usage{
readtrackData(file, na.rm = FALSE)
}
\arguments{
\item{file}{A character string specifying the path to the file containing the tracking data.}

\item{na.rm}{A logical value indicating whether to remove rows with NA values (default is FALSE).}
}
\value{
A data frame with two columns (`x` and `y`) containing the coordinates read from 
  the file. If `na.rm` is TRUE, rows with NA values are omitted.
}
\description{
Reads a text file containing tracking data, where each line represents 
coordinates. If a line contains "null", it adds NA values for that entry. Optionally, 
it can remove rows with NA values.
}
\examples{
# Read tracking data from a file
path <- system.file('extdata/track.txt', package='BioTrajectory')
tracking_data <- readtrackData(path, na.rm = TRUE)
# Print the resulting data frame
print(tracking_data)

}
