% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ae_timeline_plot.R
\name{ae_timeline_plot}
\alias{ae_timeline_plot}
\title{Outputs related adverse event timeline plots including just system organ class
(AE category), or system organ class and lowest level term (AE detail). This
function can fit up to 5 different attributions. Modify width, height and scale
parameters in ggsave() to customize fit for large plot.}
\usage{
ae_timeline_plot(
  subjID,
  subjID_ineligText = NULL,
  baseline_datasets,
  ae_dataset,
  ae_attribVars,
  ae_attribVarsName = NULL,
  ae_attribVarText = NULL,
  startDtVars,
  ae_detailVar,
  ae_categoryVar,
  ae_severityVar,
  ae_onsetDtVar,
  time_unit = c("day", "week", "month", "year"),
  include_ae_detail = TRUE,
  legendPerSpace = NULL,
  fonts = NULL,
  fontColours = NULL,
  panelColours = NULL,
  attribColours = NULL,
  attribSymbols = NULL,
  columnWidths = NULL
)
}
\arguments{
\item{subjID}{key identifier field for participant ID in data sets}

\item{subjID_ineligText}{character text that denotes participant IDs to exclude.
For example, c("New Subject") (if provided)}

\item{baseline_datasets}{list of data frames that contain baseline participant characteristics.
For example, list(enrollment_DF,demography_DF,ineligibility_DF)}

\item{ae_dataset}{data frame that contains subject AEs}

\item{ae_attribVars}{field(s) that denotes attribution to intervention
under study. For example, c("CTC_AE_ATTR_SCALE","CTC_AE_ATTR_SCALE_1")
(if provided)}

\item{ae_attribVarsName}{character text that denotes name of interventions under study.
For example, c("Drug 1", "Drug 2") (if provided)}

\item{ae_attribVarText}{character text that denotes related attribution. For example
c("Definite", "Probable", "Possible") (if provided)}

\item{startDtVars}{field(s) that denotes participant start date (i.e. 10MAY2021). For example,
it could be enrollment date or screening date. If more than one field given
(unique names are required), each field is assumed to be specific start date
for attribution in corresponding field order}

\item{ae_detailVar}{field that denotes participant AE detail (lowest level term)}

\item{ae_categoryVar}{field that denotes participant AE category (system organ class)}

\item{ae_severityVar}{field that denotes participant AE severity grade (numeric)}

\item{ae_onsetDtVar}{field that denotes participant AE onset date}

\item{time_unit}{character text that denotes time unit for desired timeline.
For example, could be one of c("day","week","month","year") (if provided)}

\item{include_ae_detail}{boolean that denotes if AE detail should be included
in timeline plot. Default is True}

\item{legendPerSpace}{parameter at denotes proportion of vertical image space
dedicated to legend at bottom. Default is 0.05 for AE detail and 0.1 for AE Category}

\item{fonts}{character text that denotes font for AE category, AE detail, axis,
legend and plot labels (if provided)}

\item{fontColours}{character text that denotes system font colours for AE category and
AE detail (if provided)}

\item{panelColours}{character text that denotes panel background colours for AE category,
AE detail and plot area (if provided)}

\item{attribColours}{character text that denotes colours for attributions, supports up to 10
distinct colours (if provided)}

\item{attribSymbols}{text that denotes median plot symbols for attributions, supports up to 10
distinct symbols (if provided)}

\item{columnWidths}{text that denotes character columns widths for AE category and AE detail
columns (if provided)}
}
\value{
ggplot object of AE timeline plot
}
\description{
Outputs related adverse event timeline plots including just system organ class
(AE category), or system organ class and lowest level term (AE detail). This
function can fit up to 5 different attributions. Modify width, height and scale
parameters in ggsave() to customize fit for large plot.
}
\examples{
data("drug1_admin", "drug2_admin", "ae");
p <- ae_timeline_plot(subjID="Subject",subjID_ineligText=c("01","11"),
                      baseline_datasets=list(drug1_admin, drug2_admin),
                      ae_dataset=ae,
                      ae_attribVars=c("CTC_AE_ATTR_SCALE","CTC_AE_ATTR_SCALE_1"),
                      ae_attribVarsName=c("Drug 1","Drug 2"),
                      ae_attribVarText=c("Definite", "Probable", "Possible"),
                      startDtVars=c("TX1_DATE_INT","TX2_DATE_INT"),
                      ae_detailVar="ae_detail",
                      ae_categoryVar="ae_category",ae_severityVar="AE_SEV_GD",
                      ae_onsetDtVar="AE_ONSET_DT_INT",time_unit="month",
                      include_ae_detail=FALSE,
                      fonts=c("Calibri","Albany AMT","Gadugi","French Script MT","Forte"),
                      fontColours=c("#FFE135"),
                      panelColours=c("#E52B50",NA,"#FFE4C4"),
                      attribColours=c("#9AB973","#01796F","#FFA343","#CC7722"),   
                      attribSymbols=c(7,8,5,6),
                      columnWidths=c(23))
}
\keyword{plot}
