% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{heart_transplant_df}
\alias{heart_transplant_df}
\title{Stanford Heart Transplant Data}
\format{
A data frame with 172 observations and 8 variables:
\describe{
\item{start}{Start time of interval (numeric)}
\item{stop}{End time of interval (numeric)}
\item{event}{Survival status (numeric: 1=event, 0=censored)}
\item{age}{Patient age at enrollment (numeric)}
\item{year}{Year of enrollment (numeric)}
\item{surgery}{Prior bypass surgery (numeric)}
\item{transplant}{Transplant status (factor: 0=no, 1=yes)}
\item{id}{Patient identification number (numeric)}
}
}
\source{
Data taken from the lrstat package version 0.2.13. Original source:
Stanford Heart Transplant Study data from the survival package.
}
\usage{
data(heart_transplant_df)
}
\description{
This dataset, heart_transplant_df, is a data frame containing survival data from
the Stanford heart transplant program. It includes information on 172 patients
with follow-up times, transplant status, and clinical covariates.
}
\details{
The dataset name has been kept as 'heart_transplant_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
CardioDataSets package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a standard data frame. The original content has not been modified
in any way.
}
