% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DosepointClass.R
\name{Dosepoint}
\alias{Dosepoint}
\title{Create a new Dosepoint object and validate it}
\usage{
Dosepoint(
  DosepointName = "A1",
  State = "Present",
  tlag = c(),
  bioavail = c(),
  duration = c(),
  rate = c(),
  PMLStructure = character()
)
}
\arguments{
\item{DosepointName}{A character string giving the name of the Dosepoint.}

\item{State}{A character string representing the state of the Dosepoint.
Possible values are:
\itemize{
\item \code{None}: current Dosepoint is not used.
\item \code{Present} (the default): current Dosepoint is used as is.
\item \code{Searched}: current Dosepoint is added as a token to be searched.
}}

\item{tlag}{An optional structural parameter giving the time lag for the
doses coming into current Dosepoint.}

\item{bioavail}{An optional structural parameter giving the bioavailability
of the doses coming into current Dosepoint.}

\item{duration}{An optional structural parameter giving the duration of
infusion for the doses coming into current Dosepoint.}

\item{rate}{An optional structural parameter giving the rate of infusion for
the doses coming into current Dosepoint.}

\item{PMLStructure}{A character string that indicates bounded PML structure.}
}
\value{
A new Dosepoint object
}
\description{
Create a new Dosepoint object and validate it
}
\examples{
TlagStParm <- StParm("Tlag",
                     Type = "LogNormal",
                     ThetaStParm = Theta(Name = "tvTlag",
                                         InitialEstimates = 0.1))

A1 <- Dosepoint(DosepointName = "A1",
                State = "Present",
                tlag = TlagStParm,
                bioavail = StParm("F"))

}
\seealso{
\code{\link[=list_Dosepoints]{list_Dosepoints()}}

Functions used for Dosepoint specification: 
\code{\link{create_ModelPK}()},
\code{\link{modify_Dosepoint}()}
}
\concept{Dosepoints}
