% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_country_info.R
\name{get_country_info}
\alias{get_country_info}
\title{Get Key Country Information from the REST Countries API}
\usage{
get_country_info(name)
}
\arguments{
\item{name}{Full country name (common or official). For example: "Chile", "Peru", "France".}
}
\value{
A data frame with 8 columns:
\itemize{
  \item \code{name_common}: Common name of the country.
  \item \code{name_official}: Official name of the country.
  \item \code{capital}: Capital city.
  \item \code{region}: Geographic region.
  \item \code{subregion}: Subregion.
  \item \code{population}: Total population.
  \item \code{area}: Total area in square kilometers.
  \item \code{languages}: Official languages, separated by commas.
}
}
\description{
Retrieves selected, essential information about Chile or any other country by its full name.
The data is retrieved from the REST Countries API.
See the API documentation at \url{https://restcountries.com/}.
Example API usage: \url{https://restcountries.com/v3.1/name/chile?fullText=true}.
}
\details{
This function returns readable details such as the country's common and official name, capital,
region, subregion, population, area, and official languages.


The function sends a GET request to the REST Countries API. If the request is successful (HTTP 200),
it parses the JSON and extracts the key fields. If the country is not found or there's an error,
the function returns \code{NULL} with a user-friendly message.
}
\examples{
\dontrun{
get_country_info("Chile")
get_country_info("Japan")
get_country_info("France")
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{tibble}}
}
