#' @export summary.clustab
#' @export
#' @name summary.clustab
#' @title Summary of a 'clustab' object
#' @description This is a method for the function summary for objects of the class
#' \code{clustab}.
#' @param object An object of class \code{clustab} generated by the function
#' \code{\link{stability}}.
#' @param \dots Further arguments passed to or from other methods.
#' @seealso \code{\link{stability}}
summary.clustab <- function(object, ...) {

  if (!inherits(object, "clustab")) 
    stop("use only with \"clustab\" objects")
  cat("\nCall:\n", deparse(object$call), "\n\n", sep = "")
  cat("\n")
}

