% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Harmonization.R
\name{comfam}
\alias{comfam}
\title{ComBat Family Harmonization}
\usage{
comfam(
  data,
  bat,
  covar = NULL,
  model = lm,
  formula = NULL,
  eb = TRUE,
  robust.LS = FALSE,
  ref.batch = NULL,
  ...
)
}
\arguments{
\item{data}{\emph{n x p} data frame or matrix of observations where
\emph{p} is the number of features and \emph{n} is the number of subjects.}

\item{bat}{Factor indicating batch (often equivalent to site or scanner)}

\item{covar}{Data frame or matrix of covariates supplied to \code{model}}

\item{model}{Model function. ComBat Family supports any models that take
arguments \code{formula} and \code{data}, but are limited to models fitting with
identity link (e.g. \code{family = gaussian(link = "identity")}). This includes
\link[stats]{lm}, \link[mgcv]{gam}, \link[gamlss]{gamlss},
\link[quantreg]{rq}, \link[lme4]{lmer}, and more}

\item{formula}{Formula for \code{model} starting with \verb{y ~} where \code{y} represents
each feature}

\item{eb}{If \code{TRUE}, uses ComBat model with empirical Bayes for mean
and variance harmonization}

\item{robust.LS}{If \code{TRUE}, uses robust location and scale estimators
for error variance and site effect parameters. Currently uses median and
biweight midvariance}

\item{ref.batch}{Reference batch, must take value in \code{levels(bat)}}

\item{...}{Additional arguments to \code{model}}
}
\value{
\code{comfam} returns a list containing the following components:
\item{dat.combat}{Harmonized data as a matrix with same dimensions as \code{data}}
\item{batch.info}{Batch information, including reference batch if specified}
\item{fits}{List of model fits from regression step, outputs of \code{model} for each feature}
\item{estimates}{List of estimates from standardization and batch effect correction}
}
\description{
Implementation of the ComBat Family of harmonization methods allowing for
flexible covariate modeling and alternative estimators for site effect
adjustment. Support for modeling of both location and scale via GAMLSS and
longitudinal harmonization via mixed effects models.
}
\examples{
comfam(iris[,1:2], iris$Species)
comfam(iris[,1:2], iris$Species, iris[3:4], lm, y ~ Petal.Length + Petal.Width)
}
\seealso{
\link[ComBatFamQC]{predict.comfam} for applying ComBat parameters for
harmonization of new observations
}
