% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/declare_sampling.R
\name{declare_sampling}
\alias{declare_sampling}
\alias{sampling_handler}
\title{Declare sampling procedure}
\usage{
declare_sampling(..., handler = sampling_handler, label = NULL)

sampling_handler(data, ..., sampling_variable = "S", drop_nonsampled = TRUE)
}
\arguments{
\item{...}{arguments to be captured, and later passed to the handler}

\item{handler}{a tidy-in, tidy-out function}

\item{label}{a string describing the step}

\item{data}{A data.frame.}

\item{sampling_variable}{The prefix for the sampling inclusion probability variable.}

\item{drop_nonsampled}{Logical indicating whether to drop units that are not sampled. Default is \code{TRUE}.}
}
\value{
A function that takes a data.frame as an argument and returns a data.frame subsetted to sampled observations and (optionally) augmented with inclusion probabilities and other quantities.
}
\description{
Declare sampling procedure
}
\details{
\code{declare_sampling} can work with any sampling_function that takes data and returns data. The default handler is \code{draw_rs} from the \code{randomizr} package. This allows quick declaration of many sampling schemes that involve strata and clusters.

The arguments to \code{\link{draw_rs}} can include N, strata, clusters, n, prob, strata_n, and strata_prob.
The arguments you need to specify are different for different designs.

Note that \code{declare_sampling} works similarly to \code{declare_assignment} a key difference being that \code{declare_sampling} functions subset data to sampled units rather than simply appending an indicator for membership of a sample (assignment). If you need to sample but keep the dataset use \code{declare_assignment} and define further steps (such as estimation) with respect to subsets defined by the assignment.

For details see the help files for \code{\link{complete_rs}}, \code{\link{strata_rs}}, \code{\link{cluster_rs}}, or \code{\link{strata_and_cluster_rs}}
}
\examples{

# Default handler is `draw_rs` from `randomizr` package

# Simple random sampling
my_sampling <- declare_sampling(n = 50)

# Stratified random sampling
my_stratified_sampling <- declare_sampling(strata = female)

# Custom random sampling functions

my_sampling_function <- function(data, n=nrow(data)) {
   data[sample(n,n,replace=TRUE), , drop=FALSE]
}

my_sampling_custom <- declare_sampling(handler = my_sampling_function)

my_sampling_custom(sleep)
}
