% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosis_helper_functions.R
\name{diagnosis_helpers}
\alias{diagnosis_helpers}
\alias{get_diagnosands}
\alias{get_simulations}
\title{Explore your design diagnosis}
\usage{
get_diagnosands(diagnosis)

get_simulations(diagnosis)
}
\arguments{
\item{diagnosis}{A design diagnosis created by \code{\link{diagnose_design}}.}
}
\description{
Explore your design diagnosis
}
\examples{
my_population <- declare_population(N = 500, noise = rnorm(N))

my_potential_outcomes <- declare_potential_outcomes(
  Y_Z_0 = noise, Y_Z_1 = noise +
  rnorm(N, mean = 2, sd = 2))

my_assignment <- declare_assignment()

my_estimand <- declare_estimand(ATE = mean(Y_Z_1 - Y_Z_0))

my_estimator <- declare_estimator(Y ~ Z, estimand = my_estimand)

my_reveal <- reveal_outcomes()

design <- my_population +
  my_potential_outcomes +
  my_estimand +
  my_assignment +
  my_reveal +
  my_estimator

\dontrun{
# using built-in defaults:
diagnosis <- diagnose_design(design)
diagnosis
}

# using a user-defined diagnosand
my_diagnosand <- declare_diagnosands(absolute_error = mean(abs(estimate - estimand)))

\dontrun{
diagnosis <- diagnose_design(design, diagnosands = my_diagnosand)
diagnosis

get_diagnosands(diagnosis)

get_simulations(diagnosis)

reshape_diagnosis(diagnosis)

}

}
