% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_helper_functions.R
\name{run_design}
\alias{run_design}
\title{Run a design one time}
\usage{
run_design(design)
}
\arguments{
\item{design}{a DeclareDesign object}
}
\description{
Run a design one time
}
\examples{
design <-
  declare_model(
    N = 100, X = rnorm(N),
    potential_outcomes(Y ~ (.25 + X) * Z + rnorm(N))
  ) +
  declare_inquiry(ATE = mean(Y_Z_1 - Y_Z_0)) +
  declare_assignment(Z = complete_ra(N, m = 50)) +
  declare_measurement(Y = reveal_outcomes(Y ~ Z)) + 
  declare_estimator(Y ~ Z, inquiry = "ATE")

run_design(design)


}
