% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_dn.R
\name{create_dn}
\alias{create_dn}
\title{Create a users distinguished name}
\usage{
create_dn(userId, ou = "EDI")
}
\arguments{
\item{userId}{(character) User identifier of an EDI data repository account}

\item{ou}{(character) Organizational unit in which \code{userId} belongs.
Can be "EDI" or "LTER". All \code{userId} issued after "2020-05-01" have
\code{ou = "EDI"}.}
}
\value{
(character) Distinguished name
}
\description{
Create a users distinguished name
}
\examples{
# For an EDI account
dn <- create_dn(userId = "my_userid", ou = "EDI")
dn

# For an LTER account
dn <- create_dn(userId = "my_userid", ou = "LTER")
dn
}
\seealso{
Other Miscellaneous: 
\code{\link{create_data_package_archive}()},
\code{\link{is_authorized}()}
}
\concept{Miscellaneous}
