% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EGM.compare.R
\name{EGM.compare}
\alias{EGM.compare}
\title{Compare \code{\link[EGAnet]{EGM}} with EFA}
\usage{
EGM.compare(data, constrained = FALSE, rotation = "geominQ", ...)
}
\arguments{
\item{data}{Matrix or data frame.
Should consist only of variables to be used in the analysis.
Can be raw data or a correlation matrix}

\item{constrained}{Boolean (length = 1).
Whether memberships of the communities should
be added as a constraint when optimizing the network loadings.
Defaults to \code{FALSE} to freely estimate each loading similar to
exploratory factor analysis.

\emph{Note: This default differs from} \code{\link[EGAnet]{EGM}}\emph{.
Constraining loadings puts EGM at a deficit relative to EFA and therefore
biases the comparability between the methods. It's best to leave the
default of unconstrained when using this function.}}

\item{rotation}{Character.
A rotation to use to obtain a simpler structure for EFA.
For a list of rotations, see \code{\link[GPArotation]{rotations}} for options.
Defaults to \code{"geominQ"}}

\item{...}{Additional arguments to be passed on to
\code{\link[EGAnet]{auto.correlate}},
\code{\link[EGAnet]{network.estimation}},
\code{\link[EGAnet]{community.detection}},
\code{\link[EGAnet]{community.consensus}},
\code{\link[EGAnet]{community.unidimensional}},
\code{\link[EGAnet]{EGA}},
\code{\link[EGAnet]{EGM}},
\code{\link[EGAnet]{net.loads}}, and
\code{\link[psych]{fa}}}
}
\description{
Estimates an \code{\link[EGAnet]{EGM}} based on \code{\link[EGAnet]{EGA}} and
uses the number of communities as the number of dimensions in exploratory factor analysis
(EFA) using \code{\link[psych]{fa}}
}
\examples{
# Get depression data
data <- depression[,24:44]

# Compare EGM (using EGA) with EFA
\dontrun{
results <- EGM.compare(data)

# Print summary
summary(results)}

}
\author{
Hudson F. Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
