% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AUCell.R
\name{AUCellfunc}
\alias{AUCellfunc}
\title{AUCell EMT Score Calculation}
\usage{
AUCellfunc(geneExp, genes)
}
\arguments{
\item{geneExp}{A matrix or data frame of gene expression data, where rows are genes and columns are cells/samples.}

\item{genes}{A vector of gene names that defines the gene set for the AUCell analysis.}
}
\value{
A data frame with two columns: `SampleID` and `AUCell`, representing the AUCell score for each cell/sample.
}
\description{
Calculate AUCell scores for a given gene set across single-cell gene expression data.
}
\examples{
library(curl)
url <- "https://zenodo.org/record/15213845/files/geneExp.rda"
destfile <- tempfile(fileext = ".rda")
download.file(url, destfile, mode = "wb")
load(destfile)
data(Panchy_et_al_E_signature)
geneList = Panchy_et_al_E_signature
genes = unlist(geneList$GeneName)
AUCellMethod = AUCellfunc(t(geneExp),genes)
}
