% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coarse2estim.R
\name{coarse2estim}
\alias{coarse2estim}
\title{Link coarseDataTools and EpiEstim}
\usage{
coarse2estim(x = NULL, dist = x@dist, samples = x@samples, thin = 10)
}
\arguments{
\item{x}{An object generated by function
\code{coarseDataTools::dic.fit.mcmc}, containing posterior estimates of the
serial interval distribution.}

\item{dist}{The parametric distribution used when estimating the serial
interval.
#' Should be one of "G" (Gamma), "W" (Weibull), "L" (Lognormal), "off1G"
(Gamma shifted by 1), "off1W" (Weibull shifted by 1), or "off1L" (Lognormal
shifted by 1).  If not present, computed automatically from \code{x}.}

\item{samples}{A dataframe containing the posterior samples of serial
interval parameters corresponding to the parametric choice specified in
\code{dist}. If not present, computed automatically from \code{x}.}

\item{thin}{A positive integer corresponding to thinning parameter; of the
posterior sample of serial interval distributions in x, only 1 in \code{thin}
 will be kept, the rest will be discarded.}
}
\value{
A list with two elements:
\itemize{
\item{si_sample: a matrix where each column gives one distribution of the
serial interval to be explored, obtained from x by thinning the MCMC chain.}
\item{si_parametric_distr: the parametric distribution used when estimating
the serial interval stored in x. }
}
}
\description{
\code{coarse2estim} Transforms outputs of
\code{coarseDataTools::dic.fit.mcmc} to right format for input into
\code{estimate_R}
}
\examples{
\dontrun{
## Note the following examples use an MCMC routine
## to estimate the serial interval distribution from data,
## so they may take a few minutes to run

## load data on rotavirus
data("MockRotavirus")

## estimate the serial interval from data
SI.fit <- coarseDataTools::dic.fit.mcmc(dat = MockRotavirus$si_data,
                     dist = "G",
                     init.pars = init_mcmc_params(MockRotavirus$si_data, "G"),
                     burnin = 1000,
                     n.samples = 5000)

## use coarse2estim to turn this in the right format for estimate_R
si_sample <- coarse2estim(SI.fit, thin = 10)$si_sample

## use estimate_R to estimate the reproduction number
## based on these estimates of the serial interval
R_si_from_sample <- estimate_R(MockRotavirus$incidence,
                            method="si_from_sample",
                            si_sample=si_sample,
                            config = make_config(list(n2 = 50)))
plot(R_si_from_sample)
}

}
\seealso{
\code{\link{estimate_R}}
}
\author{
The Hackout3 Parameter Estimation team.
}
