% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selecao.R
\name{transg}
\alias{transg}
\title{Selection Differential (Mean and Deviations)}
\usage{
transg(
  Gen,
  Var,
  Control,
  verbose = FALSE,
  plot = FALSE,
  ylab = "Selection",
  xlab = "Genotypes"
)
}
\arguments{
\item{Gen}{The column with the genotype name}

\item{Var}{The column with the values for the variable of interest}

\item{Control}{The column with the value of the variable 'X' for the controls}

\item{verbose}{Logical argument. Runs the code silently if FALSE.}

\item{plot}{Logical argument. Plots a graphic if 'TRUE'.}

\item{ylab}{The name of the Y axis.}

\item{xlab}{The name of the X axis.}
}
\value{
Returns the general parameters and the genotypes selected for each
treshold. Also plot a representative graph of the selected genotypes based on
the mean and standard deviations.
}
\description{
Selection of Transgressive Genotypes - Selection Differential (SD)
}
\examples{
library(EstimateBreed)

Gen <- paste0("G", 1:20)
Var <- round(rnorm(20, mean = 3.5, sd = 0.8), 2)
Control <- rep(3.8, 20)

data <- data.frame(Gen,Var,Control)

transg_sel <- with(data,transg(Gen,Var,Control,verbose=FALSE,plot=TRUE))
}
\author{
Willyan Junior Adorian Bandeira

Ivan Ricardo Carvalho

Murilo Vieira Loro

Leonardo Cesar Pradebon

Jose Antonio Gonzalez da Silva
}
