/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.metaAnalysis;

import dr.inference.model.CompoundLikelihood;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import java.util.ArrayList;
import java.util.List;
import org.ohdsi.data.CoxData;
import org.ohdsi.likelihood.CoxPartialLikelihood;
import org.ohdsi.metaAnalysis.DataModel;

public class CoxDataModel
implements DataModel {
    private final List<Parameter> thetaList = new ArrayList<Parameter>();
    private final List<Likelihood> likelihoodList = new ArrayList<Likelihood>();
    private CompoundLikelihood likelihood = null;
    private Parameter theta = null;

    public void addLikelihoodData(int[] nArray, int[] nArray2, double[] dArray, double[] dArray2) {
        Parameter.Default default_ = new Parameter.Default("theta" + (this.thetaList.size() + 1), 0.1, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        CoxData coxData = new CoxData(nArray, nArray2, dArray, dArray2);
        CoxPartialLikelihood coxPartialLikelihood = new CoxPartialLikelihood((Parameter)default_, coxData.getSortedData());
        this.thetaList.add((Parameter)default_);
        this.likelihoodList.add((Likelihood)coxPartialLikelihood);
    }

    public void finish() {
        this.likelihood = new CompoundLikelihood(this.likelihoodList);
        this.theta = new CompoundParameter("theta", this.thetaList.toArray(new Parameter[0]));
    }

    @Override
    public Likelihood getLikelihood() {
        return this.likelihood;
    }

    @Override
    public Parameter getCompoundParameter() {
        return this.theta;
    }

    @Override
    public List<Parameter> getIndividualParameters() {
        return this.thetaList;
    }
}

