% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSAUtils.R
\name{peek}
\alias{peek}
\title{Peek into (show a subset of) a data frame or matrix.}
\usage{
peek(x, n = 20L, which = NULL, addrownums = TRUE)
}
\arguments{
\item{x}{A data frame or matrix.}

\item{n}{A single numeric that indicates the number of rows to display.}

\item{which}{A numeric or string vector that contains the column numbers or names to display. Defaults to showing all columns.}

\item{addrownums}{If there are no row names for the MATRIX, then create them from the row numbers.}
}
\value{
A matrix or data.frame with n rows.
}
\description{
Shows the first, last, and approximately evenly spaced rows from a data frame or matrix.
}
\note{
If \code{n} is larger than the number of rows in \code{x} then all of \code{x} is displayed.
}
\examples{
peek(iris)
peek(iris,n=6)
peek(iris,n=6,which=c("Sepal.Length","Sepal.Width","Species"))
peek(iris,n=6,which=grep("Sepal",names(iris)))
peek(iris,n=200)

## Make a matrix for demonstration purposes only
miris <- as.matrix(iris[,1:4])
peek(miris)
peek(miris,n=6)
peek(miris,n=6,addrownums=FALSE)
peek(miris,n=6,which=2:4)

## Make a tbl_df type from dplyr ... note how peek() is not limited by
## the tbl_df restriction on number of rows to show (but head() is).
if (require(dplyr)) {
  iris2 <- tbl_df(iris)
  class(iris2)
  peek(iris2,n=6)
  head(iris2,n=15)
}
}
\seealso{
\code{headtail}
}
\author{
Derek H. Ogle, \email{DerekOgle51@gmail.com}

A. Powell Wheeler, \email{powell.wheeler@gmail.com}
}
\keyword{manip}
