% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_d_gnfi3.R
\name{age_d_gnfi3}
\alias{age_d_gnfi3}
\title{Inverse Stem Diameter Growth Model of the 3rd German National Forest
Inventory (2012)}
\usage{
age_d_gnfi3(species_id, dbh_cm, dbh_cm_known, age_yr_known)
}
\arguments{
\item{species_id}{Vector of species id's preferably following the
\emph{ger_nfi_2012} species coding. Ideally, these species_id's are provided as
a \code{\link{fe_species_ger_nfi_2012}} object. See Details for how other
species codings are handled.}

\item{dbh_cm}{Single numeric value or vector of dbh (cm) for which the
age is to be estimated}

\item{dbh_cm_known}{Vector of known dbh (cm) values at age
\code{age_yr_known}}

\item{age_yr_known}{Vector of ages (years) for which the dbh
\code{d_cm_known} is known}
}
\value{
A single age value or vector of age values corresponding to
\code{dbh_cm}
}
\description{
Inverse tree diameter growth model of the third German National Forest
Inventory of 2012 \insertCite{bwi3_methods_2017}{ForestElementsR}. Allows to
estimate a tree's age at any dbh if its dbh is known at a given age.
}
\details{
Originally, the function was parameterized for species and species groups
corresponding to the national forest inventory's species coding
(\code{\link{fe_species_ger_nfi_2012}}). We have attributed in addition these
the original parameters also to the species codings
\code{\link{fe_species_tum_wwk_short}}, and
\code{\link{fe_species_bavrn_state_short}}. When called with a given species
coding, the function will try to use the "nearest" of these three
alternatives. Fallback option is the attempt to use
\code{\link{fe_species_tum_wwk_short}}.
}
\examples{
  # A Norway spruce has a diameter of 17.5 cm at age 45. Estimate
  # its age at dbh 20.6 cm
  age_d_gnfi3(10, 20.6, 17.5, 45) # 10 is ger_nfi_2012 code for Norway spruce

  # Do the same backward in time, age at dbh 12.4 cm
  age_d_gnfi3(10, 12.4, 17.5, 45)

  # Apply for more than one tree, different species, same age
  d_known   <- c(23.1, 16.2, 35.2, 19.3, 21.8)
  d_age     <- c(27.0, 19.0, 40.8, 22.9, 25.8)
  species   <- as_fe_species_tum_wwk_short(c(3, 3, 3, 6, 6))
  age_d_gnfi3(
    species, dbh_cm = d_age, dbh_cm_known = d_known, age_yr_known = 40
  )

}
\references{
\insertAllCited{}
}
\seealso{
Other growth functions: 
\code{\link{age_h_gnfi3}()},
\code{\link{d_age_gnfi3}()},
\code{\link{h_age_gnfi3}()}
}
\concept{growth functions}
