% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standing_area_gnfi3.R
\name{standing_area_gnfi3}
\alias{standing_area_gnfi3}
\title{Estimate the Standing Area of Single Trees}
\usage{
standing_area_gnfi3(species_id, dbh_cm)
}
\arguments{
\item{species_id}{Vector of species id's preferably following the
\emph{ger_nfi_2012} species coding. Ideally, these species_id's are provided as
a \code{\link{fe_species_ger_nfi_2012}} object. See Details for how other
species codings are handled.}

\item{dbh_cm}{Vector of tree dbh values in cm (dbh = stem diameter at breast
height, i.e. 1.3 m)}
}
\value{
A vector of the estimated standing areas in m²
}
\description{
An implementation of the standing area estimation of the third German
National Forest Inventory \insertCite{bwi3_methods_2017}{ForestElementsR}.
Its main intended use is the calculation of virtual species areas in mixed
stands. According to \insertCite{bwi3_methods_2017}{ForestElementsR}, it is
recommended only to include the main stand in such calculations, neither
understorey, nor any layers above the main stand.
}
\details{
Originally, the function was parameterized for species and species groups
corresponding to the national forest inventory's species coding
(\code{\link{fe_species_ger_nfi_2012}}). We have attributed in addition these
the original parameters also to the species codings
\code{\link{fe_species_tum_wwk_short}}, and
\code{\link{fe_species_bavrn_state_short}}. When called with a given species
coding, the function will try to use the "nearest" of these three
alternatives. Fallback option is the attempt to use
\code{\link{fe_species_tum_wwk_short}}.
}
\examples{
  # Three spruces, two pines, two beech
  species_id <- fe_species_ger_nfi_2012(c(10, 10, 10, 20, 20, 100, 100))
  dbh_cm     <- c(10.1, 27.4, 31.4, 35.5, 39.8, 45.2, 47.2)

  standing_area_gnfi3(species_id, dbh_cm)

}
