% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyImputation.R
\name{FuzzyImputation}
\alias{FuzzyImputation}
\title{Main method to impute fuzzy values.}
\usage{
FuzzyImputation(
  dataToImpute,
  method = "dimp",
  trapezoidal = TRUE,
  checkFuzzy = FALSE,
  verbose = TRUE,
  pmmWarnings = TRUE,
  ...
)
}
\arguments{
\item{dataToImpute}{Name of the input matrix (data frame or list) of fuzzy numbers with some NAs.}

\item{method}{Name of the imputation method (possible values: \code{dimp,missForest,miceRanger,knn,pmm}).}

\item{trapezoidal}{Logical value depending on the type of fuzzy values (triangular or trapezoidal ones) in the dataset.}

\item{checkFuzzy}{If \code{TRUE} is set, after each imputation, the output values are checked if they are proper fuzzy numbers.
If there are some improper fuzzy numbers, they are removed, and the imputation procedure is repeated.}

\item{verbose}{If \code{TRUE} is set, the current simulation number is printed.}

\item{pmmWarnings}{Suppress warnings from \code{pmm} method.}

\item{...}{Additional parameters that are passed to the imputation procedure.}
}
\value{
The output is given as a matrix.
}
\description{
`FuzzyImputation` imputes (i.e., replaces missing values) fuzzy numbers using various methods.
}
\details{
The procedure randomly imputes missing values (NAs) with suitable data in the case of a data frame (or a matrix, or a list)
consisting of fuzzy numbers (triangular fuzzy numbers if \code{trapezoidal=FALSE} is set, or trapezoidal ones if the default
\code{trapezoidal=TRUE} is used).
The output is given as a matrix without NAs, where each row is related to fuzzy numbers (given by 3 values for the triangular fuzzy numbers,
or 4 values in the case of trapezoidal ones) for the consecutive variables.
Many fuzzy variables (not only the single one) can be used. 
The input has to consist of fuzzy numbers of the same type (i.e., mixing triangular and trapezoidal fuzzy numbers is not allowed).

Various possible imputation methods can be used when the parameter \code{method} is specified --
 both the general ones (\code{missForest} or \code{miceRanger} from the respective packages, or \code{knn} from
 \code{VIM} package, or \code{pmm} from \code{mice} package) and a more specific ones, tailored for the fuzzy data (\code{dimp} in the case of the DIMP method).
Please note that due to the imputation, some output values can be improper fuzzy variables 
(e.g., a core of a fuzzy number can have greater value than its right end of the support).
To avoid this, \code{checkFuzzy=TRUE} should be set.
In this case, the imputation procedure is repeated until all of the results are proper triangular or trapezoidal fuzzy numbers.
The improper values are removed and replaced with the respective fuzzy numbers from the input dataset.
However, many repetitions (even unacceptably many) are then possible.
}
\examples{



# seed PRNG

set.seed(1234)

# load the necessary library

library(FuzzySimRes)

# generate sample of trapezoidal fuzzy numbers with FuzzySimRes library

list1<-SimulateSample(20,originalPD="rnorm",parOriginalPD=list(mean=0,sd=1),
incrCorePD="rexp", parIncrCorePD=list(rate=2),
suppLeftPD="runif",parSuppLeftPD=list(min=0,max=0.6),
suppRightPD="runif", parSuppRightPD=list(min=0,max=0.6),
type="trapezoidal")

# convert fuzzy data into a matrix

matrix1 <- FuzzyNumbersToMatrix(list1$value)

# check starting values

head(matrix1)

# add some NAs to the matrix

matrix1NA <- IntroducingNA(matrix1,percentage = 0.1)

head(matrix1NA)

# impute missing values with the DIMP method

set.seed(12345)

FuzzyImputation(matrix1NA)

# impute missing values with the miceRanger method

set.seed(12345)

FuzzyImputation(matrix1NA,method = "miceRanger")


}
