% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemIntertemporal_3_4.R
\name{gemIntertemporal_3_4}
\alias{gemIntertemporal_3_4}
\title{An Intertemporal Model with Two Consumers and Two Types of Firms}
\usage{
gemIntertemporal_3_4(...)
}
\arguments{
\item{...}{arguments to be passed to the function sdm2.}
}
\description{
An intertemporal (timeline) model with two consumers and two types of firms.
}
\examples{
\donttest{
#### an example with Cobb-Douglas production functions and intertemporal utility functions.
np <- 5 # the number of economic periods

n <- 3 * np - 1 # the number of commodity kinds
m <- 2 * (np - 1) + 2 # the number of agent kinds

names.commodity <- c(
  paste0("corn", 1:np),
  paste0("iron", 1:np),
  paste0("lab", 1:(np - 1))
)
names.agent <- c(
  paste0("firm.corn", 1:(np - 1)),
  paste0("firm.iron", 1:(np - 1)),
  "consumer1", "consumer2"
)

# the exogenous supply matrix.
S0Exg <- matrix(NA, n, m, dimnames = list(names.commodity, names.agent))
S0Exg[paste0("lab", 1:(np - 1)), c("consumer1", "consumer2")] <- 100
S0Exg["corn1", c("consumer1", "consumer2")] <- 25
S0Exg["iron1", c("consumer1", "consumer2")] <- 100

# the output coefficient matrix.
B <- matrix(0, n, m, dimnames = list(names.commodity, names.agent))
for (k in 1:(np - 1)) {
  B[paste0("corn", k + 1), paste0("firm.corn", k)] <-
    B[paste0("iron", k + 1), paste0("firm.iron", k)] <- 1
}

dstl.firm.corn <- dstl.firm.iron <- list()
for (k in 1:(np - 1)) {
  dstl.firm.corn[[k]] <- node_new(
    "prod",
    type = "CD", alpha = 1, beta = c(0.5, 0.5),
    paste0("iron", k), paste0("lab", k)
  )

  dstl.firm.iron[[k]] <- node_new(
    "prod",
    type = "CD", alpha = 2, beta = c(0.5, 0.5),
    paste0("iron", k), paste0("lab", k)
  )
}

dst.consumer1 <- node_new(
  "util",
  type = "CD", alpha = 1, beta = prop.table(rep(1, np)),
  paste0("corn", 1:np)
)

dst.consumer2 <- node_new(
  "util",
  type = "CD", alpha = 1, beta = prop.table(rep(1, np)),
  paste0("cc", 1:np)
)
for (k in 1:np) {
  node_set(
    dst.consumer2,
    paste0("cc", k),
    type = "CD", alpha = 1, beta = c(0.5, 0.5),
    paste0("corn", k), paste0("iron", k)
  )
}

ge <- sdm2(
  A = c(dstl.firm.corn, dstl.firm.iron, dst.consumer1, dst.consumer2),
  B = B,
  S0Exg = S0Exg,
  names.commodity = names.commodity,
  names.agent = names.agent,
  numeraire = "lab1",
  ts = TRUE
)

ge$p
ge$z
ge$D
ge$S
ge$DV
ge$SV
}
}
