% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_grid.R
\name{p.grid}
\alias{p.grid}
\title{Evaluates the distribution function of a grid type copula}
\usage{
p.grid(U, V = NULL, gc)
}
\arguments{
\item{U}{a matrix of size \eqn{nx2} with the observed values. It can also be a vector of size \eqn{kx1} with the values of the \eqn{U_1} variable.}

\item{V}{optional, a vector of size \eqn{kx1} with the values of the\eqn{U_2} variable.}

\item{gc}{a grid type copula object.}
}
\value{
Returns a vector with the corresponding distribution.
}
\description{
Returns the corresponding distribution function values.
}
\examples{
# Generating simulated data with a transformation to the copula domain
n <- 500
x <- rgamma(n,4,1/2)
e <- rnorm(n,0,.3)
y <- sin(x+e)
Fx <- ecdf(x)
Fy <- ecdf(y)
u <- Fx(x)
v <- Fy(y)
df <- cbind(u,v)
copula.grid <- estimate.gridCopula(U = df, k = 5, m = 4 , method = "ml")
p.grid(df,gc=copula.grid)

# Using the Iris dataset, transformation is not mandatory
copula.grid <- estimate.gridCopula(X = iris[,1:2], k = 3, m = 7 , method = "ml")
p.grid(copula.grid$U,gc=copula.grid)
}
