% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.gwlfit.R
\name{print.gwlfit}
\alias{print.gwlfit}
\title{Printing gwlfit objects}
\usage{
\method{print}{gwlfit}(x, ...)
}
\arguments{
\item{x}{a \code{gwlfit} object}

\item{...}{ellipsis for S3 method compatibility}
}
\value{
this function print key elements of a \code{gwlfit} object
}
\description{
Printing gwlfit objects
}
\examples{
predictors <- matrix(data = rnorm(2500), 50,50)
y_value <- sample(1:1000, 50)
coords <- data.frame("Lat" = rnorm(50), "Long" = rnorm(50))
distance_matrix <- compute_distance_matrix(coords)

my.gwl.fit <- gwl_fit(bw = 20,
                      x.var = predictors, 
                      y.var = y_value,
                      kernel = "bisquare",
                      dist.mat = distance_matrix, 
                      alpha = 1, 
                      adaptive = TRUE, 
                      progress = TRUE,
                      nfolds = 5)

my.gwl.fit


}
