% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asca_plots.R
\name{timeplot}
\alias{timeplot}
\title{Timeplot for Combined Effects}
\usage{
timeplot(
  object,
  factor,
  time,
  comb,
  comp = 1,
  ylim,
  x_time = FALSE,
  xlab = time,
  ylab = paste0("Score ", comp),
  lwd = 2,
  ...
)
}
\arguments{
\item{object}{\code{asca} object.}

\item{factor}{\code{integer/character} main factor.}

\item{time}{\code{integer/character} time factor.}

\item{comb}{\code{integer/character} combined effect factor.}

\item{comp}{\code{integer} component number.}

\item{ylim}{\code{numeric} y limits.}

\item{x_time}{\code{logical} use time levels as non-equispaced x axis (default = FALSE).}

\item{xlab}{\code{character} x label.}

\item{ylab}{\code{character} y label.}

\item{lwd}{\code{numeric} line width.}

\item{...}{additional arguments to \code{plot}.}
}
\value{
Nothing
}
\description{
Timeplot for Combined Effects
}
\examples{
data("caldana")
mod.comb <- asca(compounds ~ time + comb(light + light:time), data=caldana)

# Default time axis
timeplot(mod.comb, factor="light", time="time", comb=2)

# Non-equispaced time axis (using time levels)
timeplot(mod.comb, factor="light", time="time", comb=2, x_time=TRUE)

# Second component
timeplot(mod.comb, factor="light", time="time", comb=2, comp=2, x_time=TRUE)
}
