% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_related_functions.R
\name{ReadAndSplitMutectVCFs}
\alias{ReadAndSplitMutectVCFs}
\title{\strong{[Deprecated, use ReadAndSplitVCFs(variant.caller = "mutect") instead]}
Read and split Mutect VCF files}
\usage{
ReadAndSplitMutectVCFs(
  files,
  names.of.VCFs = NULL,
  tumor.col.names = NA,
  suppress.discarded.variants.warnings = TRUE
)
}
\arguments{
\item{files}{Character vector of file paths to the Mutect VCF files.}

\item{names.of.VCFs}{Optional. Character vector of names of the VCF files.
The order of names in \code{names.of.VCFs} should match the order of VCF
file paths in \code{files}. If \code{NULL}(default), this function will
remove all of the path up to and including the last path separator (if any)
in \code{files} and file paths without extensions (and the leading dot)
will be used as the names of the VCF files.}

\item{tumor.col.names}{Optional. Vector of column names or column indices in
VCFs which contain the tumor sample information. The order of elements in
\code{tumor.col.names} should match the order of VCFs specified in
\code{files}. If \code{tumor.col.names} is equal to \code{NA}(default),
this function will use the 10th column in all the VCFs to calculate VAFs.
See \code{\link{GetMutectVAF}} for more details.}

\item{suppress.discarded.variants.warnings}{Logical. Whether to suppress
warning messages showing information about the discarded variants. Default
is TRUE.}
}
\description{
\strong{[Deprecated, use ReadAndSplitVCFs(variant.caller = "mutect") instead]}
Read and split Mutect VCF files
}
\section{Value}{
 A list containing the following objects:
\itemize{
\item \code{SBS}: List of VCFs with only single base substitutions.
\item \code{DBS}: List of VCFs with only doublet base substitutions as called
by Mutect.
\item \code{ID}: List of VCFs with only small insertions and deletions.
\item \code{discarded.variants}: \strong{Non-NULL only if} there are variants
that were excluded from the analysis. See the added extra column
\code{discarded.reason} for more details.
}
}

\examples{
\dontrun{
file <- c(system.file("extdata/Mutect-vcf",
                      "Mutect.GRCh37.s1.vcf",
                      package = "ICAMS"))
list.of.vcfs <- ReadAndSplitMutectVCFs(file)
}  
}
\seealso{
\code{\link{MutectVCFFilesToCatalog}}
}
