% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.INLAjoint.R
\name{predict.INLAjoint}
\alias{predict.INLAjoint}
\title{Computes predictions for a given model fitted with INLAjoint}
\usage{
\method{predict}{INLAjoint}(
  object,
  newData = NULL,
  timePoints = NULL,
  NtimePoints = 50,
  strategy = 1,
  Nsample = 300,
  NsampleRE = 50,
  loopRE = FALSE,
  id = NULL,
  Csurv = NULL,
  horizon = NULL,
  baselineHaz = "interpolation",
  return.samples = FALSE,
  survival = FALSE,
  CIF = FALSE,
  inv.link = FALSE,
  ...
)
}
\arguments{
\item{object}{an object that contains a model fitted with INLAjoint.}

\item{newData}{a dataset with the same columns as those used to fit the model. When using a longitudinal
marker to predict longitudinal and subsequent survival outcomes, only the longitudinal information (i.e.,
structure of the longitudinal data) is required. It is also possible to predict the average trajectories
conditional on covariates by setting the value of the longitudinal outcomes included in the model to NA.}

\item{timePoints}{a vector of the time points at which predictions are computed (for both longitudinal
and survival outcomes), this also control the precision of the integration for time-dependent shared
terms and the computation of cumulative risks (e.g., for survival or CIF curves), thus many time points
will increase the accuracy of predictions. Default is NULL as these time points are automatically computed
when not defined manually.}

\item{NtimePoints}{number of time points at which the predictions are computed (for both longitudinal
and survival outcomes), these time points are equidistant between time 0 and horizon time.
This also control the precision of the integration for time-dependent shared
terms and the computation of cumulative risks (e.g., for survival or CIF curves), thus many time points
will increase the accuracy of predictions.}

\item{strategy}{strategy to compute predictions. Only strategy 1 is implemented at the moment, soon
more efficient strategies are going to be implemented to allow for large scale preeictions.}

\item{Nsample}{number of samples for fixed effects and hyperparameters used to assess uncertainty
when computing predictions. Default is 300.}

\item{NsampleRE}{number of random effects realizations for each sample specified in 'Nsample'. These
random effects realizations are conditional on observed longitudinal outcomes values provided in
'newData'. When outcomes are set to NA, the realizations are sampled from the marginal distribution
of random effects.}

\item{loopRE}{boolean with default to FALSE. When 'NsampleRE' and 'Nsample' are large, the amount of
information to store in the random access memory of the computer can be large (creation of large matrices
for the computation of predictions), turning this boolean to TRUE will decompose the computation of
predictions to avoid reaching the limit of RAM of the computer (which would crash the program).}

\item{id}{name of the individual id variable, default is NULL as it is automatically grabbed from the
fitted model but when fitting simple survival models, providing id when fitting the model is not
mandatory and thus this can be useful (an explicit message is printed in this specific case).}

\item{Csurv}{conditional survival, gives the starting value of the at-risk period (i.e., starting value
at which risk predictions for survival models are computed).
Default is the last longitudinal observation time provided in 'newData' but this is
replaced by the value of 'Csurv' when provided.}

\item{horizon}{horizon of the prediction.}

\item{baselineHaz}{method used to evaluate the baseline hazard value, default is 'interpolation'
which is currently recommended. Experimental alternatives are being developed, including 'splines'
for an interpolation with splines but has not been properly validated with simulations yet.}

\item{return.samples}{boolean, when set to TRUE the samples are returned instead of summary
statistics over the samples. Default is FALSE.}

\item{survival}{boolean, when set to TRUE the summary statistics over survival functions are
computed in addition to the summary statistics over the risk functions.}

\item{CIF}{boolean, when set to TRUE the summary statistics over cumulative incidence functions are
computed in addition to the summary statistics over the risk functions. Only applies to competing risks.}

\item{inv.link}{boolean, when set to TRUE the summary statistics are computed over the predictions of
longitudinal components after applying the inverse link function for each samples in addition to the
summary statistics over the linear predictors.}

\item{...}{Extra arguments.}
}
\description{
This function allows to compute predictions for a given model fitted with INLAjoint,
the default behavior (without arguments) returns fitted values for each component of the model. It
is also possible to supply a dataset for which predictions are required, this dataset must have
the same structure as the dataset used for the model fitting (i.e., same columns). The default
returned predictions corresponds to the linear predictors for each outcomes.
}
