% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stModel.define.R
\name{stModel.define}
\alias{stModel.define}
\title{Define a spacetime model object for the \code{f()} call.}
\usage{
stModel.define(
  smesh,
  tmesh,
  model,
  control.priors,
  constr = FALSE,
  debug = FALSE,
  useINLAprecomp = TRUE,
  libpath = NULL
)
}
\arguments{
\item{smesh}{a spatial mesh}

\item{tmesh}{a temporal mesh}

\item{model}{a three characters string to specify the
smoothness alpha (each one as integer) parameters.
Currently it considers the \code{102}, \code{121}, \code{202} and \code{220} models.}

\item{control.priors}{a named list with parameter priors.
E.g. prior.rs, prior.rt and prior.sigma
as vectors with length two (U, a) to define the
corresponding PC-prior such that
P(r_s<U)=a, P(r_t<U)=a or P(sigma>U)=a.
If a=0 then U is taken to be the fixed value of the parameter.}

\item{constr}{logical to indicate if the integral of the field
over the domain is to be constrained to zero. Default value is FALSE.}

\item{debug}{integer indicating the verbose level.
Will be used as logical by INLA.}

\item{useINLAprecomp}{logical indicating if is to be used
shared object pre-compiled by INLA. Not considered if
libpath is provided.}

\item{libpath}{string to the shared object. Default is NULL.}
}
\value{
objects to be used in the f() formula term in INLA.
}
\description{
Define a spacetime model object for the \code{f()} call.
}
\details{
The matrices of the kronecker product in Theorem 4.1 of
Lindgren et. al. (2024) are computed with the
\link{stModel.matrices} and the parameters are as Eq (19-21),
but parametrized in log scale.
}
\references{
Lindgren et. al. (2024).
A diffusion-based spatio-temporal extension of Gaussian Matérn fields.
\href{https://www.idescat.cat/sort/sort481/48.1.1.Lindgren-etal.pdf}{SORT 48 (1), 3-66}
}
