% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgeneric_utils.R
\name{cgeneric_get}
\alias{cgeneric_get}
\alias{initial.cgeneric}
\alias{mu.cgeneric}
\alias{prior.cgeneric}
\alias{graph.cgeneric}
\alias{prec.cgeneric}
\title{\code{cgeneric_get} is an internal function used by
\code{graph}, \code{pred}, \code{initial}, \code{mu} or \code{prior}
methods for \code{cgeneric}.}
\usage{
cgeneric_get(
  model,
  cmd = c("graph", "Q", "initial", "mu", "log_prior"),
  theta,
  optimize = TRUE
)

\method{initial}{cgeneric}(model)

\method{mu}{cgeneric}(model, theta)

\method{prior}{cgeneric}(model, theta)

\method{graph}{cgeneric}(model, optimize)

\method{prec}{cgeneric}(model, theta, optimize)
}
\arguments{
\item{model}{a \code{cgeneric} object.}

\item{cmd}{an string to specify which model element to get}

\item{theta}{numeric vector with the model parameters.
If missing, the \code{\link[=initial]{initial()}} will be used.}

\item{optimize}{logical indicating if it is to be
returned only the elements and not as a sparse matrix.}
}
\value{
depends on \code{cmd}

numeric scalar (if numeric vector is provided
for theta) or vector (if numeric matrix is provided
for theta).
}
\description{
The \code{generic_get} retrieve a model property specified by
\code{cmd} on an \code{cgeneric} object.
The functions listed below are for each \code{cmd} case.
}
\section{Functions}{
\itemize{
\item \code{initial(cgeneric)}: Retrive the initial parameter(s) of an \code{cgeneric} model.

\item \code{mu(cgeneric)}: Evaluate the mean for an \code{cgeneric} model.

\item \code{prior(cgeneric)}: Evaluate the prior for an \code{cgeneric} model

\item \code{graph(cgeneric)}: Retrieve the graph of an \code{cgeneric} object

\item \code{prec(cgeneric)}: Retrieve the precision of an \code{cgeneric} object

}}
\examples{
old.par <- par(no.readonly = TRUE)

## Setting the prior parameters
prior.par <- c(1, 0.5) # P(sigma > 1) = 0.5
cmodel <- cgeneric(
  model = "iid", n = 10,
  param = c(prior.par), useINLAprecomp = FALSE)

## prior summaries: sigma and log-precision
(lamb <- -log(prior.par[2])/prior.par[1])
(smedian <- qexp(0.5, lamb))
(smean <- 1/lamb)

## mode: at the minimum of - log-prior
(lpmode <- optimize(function(x)
  -prior(cmodel, theta = x),
  c(-10, 30))$minimum)
## mean: integral of x*f(x)dx
(lpmean <- integrate(function(x)
  exp(prior(cmodel, theta = matrix(x, 1)))*x,
  -10, 30)$value)

## prior visualization: log(precision) and sigma
par(mfrow = c(1, 2))
plot(function(x)
 exp(prior(cmodel, theta = matrix(x, nrow=1))),
  -3, 3, n = 601, xlab = "log-precision",
  ylab = "density")
abline(v = lpmode, lwd = 3, col = 2)
rug(-2*log(smedian), lwd = 3, col = 3)
rug(lpmean, lwd = 3, col = 4)
plot(function(x)
 exp(prior(cmodel,
  theta = matrix(
    -2*log(x),
    nrow = 1))+log(2)-log(x)),
  1/100, 10, n = 1000,
  xlab = expression(sigma),
  ylab = "density")
plot(function(x) dexp(x, lamb),
   1/100, 10, n = 1000,
   add = TRUE, lty = 2, col = 2)
rug(smedian, lwd = 3, col = 3)
rug(smean, lwd = 3, col = 4)
par(old.par)
}
\seealso{
check the examples in \code{\link[=cgeneric_generic0]{cgeneric_generic0()}}

\code{\link[=cgeneric_generic0]{cgeneric_generic0()}}
}
