/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix1DProcedure;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix2DTest;
import cern.colt.matrix.tint.impl.DiagonalIntMatrix2D;
import cern.jet.math.tint.IntFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;

public class DiagonalIntMatrix2DTest
extends IntMatrix2DTest {
    protected int DLENGTH;
    protected int DINDEX;

    public DiagonalIntMatrix2DTest(String string) {
        super(string);
    }

    protected void createMatrices() throws Exception {
        this.DINDEX = 3;
        this.A = new DiagonalIntMatrix2D(this.NROWS, this.NCOLUMNS, this.DINDEX);
        this.B = new DiagonalIntMatrix2D(this.NROWS, this.NCOLUMNS, this.DINDEX);
        this.Bt = new DiagonalIntMatrix2D(this.NCOLUMNS, this.NROWS, -this.DINDEX);
        this.DLENGTH = ((DiagonalIntMatrix2D)this.A).diagonalLength();
    }

    protected void populateMatrices() {
        ConcurrencyUtils.setThreadsBeginN_2D(1);
        if (this.DINDEX >= 0) {
            int n;
            for (n = 0; n < this.DLENGTH; ++n) {
                this.A.setQuick(n, n + this.DINDEX, Math.max(1, this.rand.nextInt() % this.A.rows()));
            }
            for (n = 0; n < this.DLENGTH; ++n) {
                this.B.setQuick(n, n + this.DINDEX, Math.max(1, this.rand.nextInt() % this.A.rows()));
            }
            for (n = 0; n < this.DLENGTH; ++n) {
                this.Bt.setQuick(n - this.DINDEX, n, Math.max(1, this.rand.nextInt() % this.A.rows()));
            }
        } else {
            int n;
            for (n = 0; n < this.DLENGTH; ++n) {
                this.A.setQuick(n - this.DINDEX, n, Math.max(1, this.rand.nextInt() % this.A.rows()));
            }
            for (n = 0; n < this.DLENGTH; ++n) {
                this.B.setQuick(n - this.DINDEX, n, Math.max(1, this.rand.nextInt() % this.A.rows()));
            }
            for (n = 0; n < this.DLENGTH; ++n) {
                this.Bt.setQuick(n, n + this.DINDEX, Math.max(1, this.rand.nextInt() % this.A.rows()));
            }
        }
    }

    public void testAssignInt() {
        int n = Math.max(1, this.rand.nextInt() % this.A.rows());
        this.A.assign(n);
        if (this.DINDEX >= 0) {
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalIntMatrix2DTest.assertEquals((int)n, (int)this.A.getQuick(i, i + this.DINDEX));
            }
        } else {
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalIntMatrix2DTest.assertEquals((int)n, (int)this.A.getQuick(i - this.DINDEX, i));
            }
        }
    }

    public void testAssignIntArrayArray() {
        int n;
        int[][] nArray = new int[this.NROWS][this.NCOLUMNS];
        for (n = 0; n < this.NROWS; ++n) {
            for (int i = 0; i < this.NCOLUMNS; ++i) {
                nArray[n][i] = Math.max(1, this.rand.nextInt() % this.A.rows());
            }
        }
        this.A.assign(nArray);
        if (this.DINDEX >= 0) {
            for (n = 0; n < this.DLENGTH; ++n) {
                DiagonalIntMatrix2DTest.assertEquals((int)nArray[n][n + this.DINDEX], (int)this.A.getQuick(n, n + this.DINDEX));
            }
        } else {
            for (n = 0; n < this.DLENGTH; ++n) {
                DiagonalIntMatrix2DTest.assertEquals((int)nArray[n - this.DINDEX][n], (int)this.A.getQuick(n - this.DINDEX, n));
            }
        }
    }

    public void testAssignIntFunction() {
        IntMatrix2D intMatrix2D = this.A.copy();
        this.A.assign(IntFunctions.neg);
        if (this.DINDEX >= 0) {
            for (int i = 0; i < this.DLENGTH; ++i) {
                int n = -intMatrix2D.getQuick(i, i + this.DINDEX);
                DiagonalIntMatrix2DTest.assertEquals((int)n, (int)this.A.getQuick(i, i + this.DINDEX));
            }
        } else {
            for (int i = 0; i < this.DLENGTH; ++i) {
                int n = -intMatrix2D.getQuick(i - this.DINDEX, i);
                DiagonalIntMatrix2DTest.assertEquals((int)n, (int)this.A.getQuick(i - this.DINDEX, i));
            }
        }
    }

    public void testAssignIntMatrix2DIntIntFunction() {
        IntMatrix2D intMatrix2D = this.A.copy();
        this.A.assign(this.B, IntFunctions.div);
        if (this.DINDEX >= 0) {
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalIntMatrix2DTest.assertEquals((int)(intMatrix2D.getQuick(i, i + this.DINDEX) / this.B.getQuick(i, i + this.DINDEX)), (int)this.A.getQuick(i, i + this.DINDEX));
            }
        } else {
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalIntMatrix2DTest.assertEquals((int)(intMatrix2D.getQuick(i - this.DINDEX, i) / this.B.getQuick(i - this.DINDEX, i)), (int)this.A.getQuick(i - this.DINDEX, i));
            }
        }
    }

    public void testAssignIntMatrix2DIntIntFunctionIntArrayListIntArrayList() {
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        if (this.DINDEX >= 0) {
            for (int i = 0; i < this.DLENGTH; ++i) {
                intArrayList.add(i);
                intArrayList2.add(i + this.DINDEX);
            }
            IntMatrix2D intMatrix2D = this.A.copy();
            this.A.assign(this.B, IntFunctions.div, intArrayList, intArrayList2);
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalIntMatrix2DTest.assertEquals((int)(intMatrix2D.getQuick(i, i + this.DINDEX) / this.B.getQuick(i, i + this.DINDEX)), (int)this.A.getQuick(i, i + this.DINDEX));
            }
        } else {
            for (int i = 0; i < this.DLENGTH; ++i) {
                intArrayList.add(i - this.DINDEX);
                intArrayList2.add(i);
            }
            IntMatrix2D intMatrix2D = this.A.copy();
            this.A.assign(this.B, IntFunctions.div, intArrayList, intArrayList2);
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalIntMatrix2DTest.assertEquals((int)(intMatrix2D.getQuick(i - this.DINDEX, i) / this.B.getQuick(i - this.DINDEX, i)), (int)this.A.getQuick(i - this.DINDEX, i));
            }
        }
    }

    public void testCardinality() {
        int n = this.A.cardinality();
        DiagonalIntMatrix2DTest.assertEquals((int)this.DLENGTH, (int)n);
    }

    public void testMaxLocation() {
        this.A.assign(0);
        if (this.DINDEX >= 0) {
            this.A.setQuick(this.NROWS / 3, this.NROWS / 3 + this.DINDEX, 7);
            this.A.setQuick(this.NROWS / 2, this.NROWS / 2 + this.DINDEX, 1);
            int[] nArray = this.A.getMaxLocation();
            DiagonalIntMatrix2DTest.assertEquals((int)7, (int)nArray[0]);
            DiagonalIntMatrix2DTest.assertEquals((int)(this.NROWS / 3), (int)nArray[1]);
            DiagonalIntMatrix2DTest.assertEquals((int)(this.NROWS / 3 + this.DINDEX), (int)nArray[2]);
        } else {
            this.A.setQuick(this.NROWS / 3 - this.DINDEX, this.NROWS / 3, 7);
            this.A.setQuick(this.NROWS / 2 - this.DINDEX, this.NROWS / 2, 1);
            int[] nArray = this.A.getMaxLocation();
            DiagonalIntMatrix2DTest.assertEquals((int)7, (int)nArray[0]);
            DiagonalIntMatrix2DTest.assertEquals((int)(this.NROWS / 3 - this.DINDEX), (int)nArray[1]);
            DiagonalIntMatrix2DTest.assertEquals((int)(this.NROWS / 3), (int)nArray[2]);
        }
    }

    public void testMinLocation() {
        this.A.assign(0);
        if (this.DINDEX >= 0) {
            this.A.setQuick(this.NROWS / 3, this.NROWS / 3 + this.DINDEX, -7);
            this.A.setQuick(this.NROWS / 2, this.NROWS / 2 + this.DINDEX, -1);
            int[] nArray = this.A.getMinLocation();
            DiagonalIntMatrix2DTest.assertEquals((int)-7, (int)nArray[0]);
            DiagonalIntMatrix2DTest.assertEquals((int)(this.NROWS / 3), (int)nArray[1]);
            DiagonalIntMatrix2DTest.assertEquals((int)(this.NROWS / 3 + this.DINDEX), (int)nArray[2]);
        } else {
            this.A.setQuick(this.NROWS / 3 - this.DINDEX, this.NROWS / 3, -7);
            this.A.setQuick(this.NROWS / 2 - this.DINDEX, this.NROWS / 2, -1);
            int[] nArray = this.A.getMinLocation();
            DiagonalIntMatrix2DTest.assertEquals((int)-7, (int)nArray[0]);
            DiagonalIntMatrix2DTest.assertEquals((int)(this.NROWS / 3 - this.DINDEX), (int)nArray[1]);
            DiagonalIntMatrix2DTest.assertEquals((int)(this.NROWS / 3), (int)nArray[2]);
        }
    }

    public void testGetNegativeValues() {
        this.A.assign(0);
        if (this.DINDEX >= 0) {
            this.A.setQuick(this.NROWS / 3, this.NROWS / 3 + this.DINDEX, -7);
            this.A.setQuick(this.NROWS / 2, this.NROWS / 2 + this.DINDEX, -1);
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList2 = new IntArrayList();
            IntArrayList intArrayList3 = new IntArrayList();
            this.A.getNegativeValues(intArrayList, intArrayList2, intArrayList3);
            DiagonalIntMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
            DiagonalIntMatrix2DTest.assertEquals((int)2, (int)intArrayList2.size());
            DiagonalIntMatrix2DTest.assertEquals((int)2, (int)intArrayList3.size());
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 3));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 2));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 3 + this.DINDEX));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 2 + this.DINDEX));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList3.contains(-7));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList3.contains(-1));
        } else {
            this.A.setQuick(this.NROWS / 3 - this.DINDEX, this.NROWS / 3, -7);
            this.A.setQuick(this.NROWS / 2 - this.DINDEX, this.NROWS / 2, -1);
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList4 = new IntArrayList();
            IntArrayList intArrayList5 = new IntArrayList();
            this.A.getNegativeValues(intArrayList, intArrayList4, intArrayList5);
            DiagonalIntMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
            DiagonalIntMatrix2DTest.assertEquals((int)2, (int)intArrayList4.size());
            DiagonalIntMatrix2DTest.assertEquals((int)2, (int)intArrayList5.size());
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 3 - this.DINDEX));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 2 - this.DINDEX));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList4.contains(this.NROWS / 3));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList4.contains(this.NROWS / 2));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList5.contains(-7));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList5.contains(-1));
        }
    }

    public void testGetNonZeros() {
        this.A.assign(0);
        if (this.DINDEX >= 0) {
            this.A.setQuick(this.NROWS / 3, this.NROWS / 3 + this.DINDEX, 7);
            this.A.setQuick(this.NROWS / 2, this.NROWS / 2 + this.DINDEX, 1);
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList2 = new IntArrayList();
            IntArrayList intArrayList3 = new IntArrayList();
            this.A.getNonZeros(intArrayList, intArrayList2, intArrayList3);
            DiagonalIntMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
            DiagonalIntMatrix2DTest.assertEquals((int)2, (int)intArrayList2.size());
            DiagonalIntMatrix2DTest.assertEquals((int)2, (int)intArrayList3.size());
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 3));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 2));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 3 + this.DINDEX));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 2 + this.DINDEX));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList3.contains(7));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList3.contains(1));
        } else {
            this.A.setQuick(this.NROWS / 3 - this.DINDEX, this.NROWS / 3, 7);
            this.A.setQuick(this.NROWS / 2 - this.DINDEX, this.NROWS / 2, 1);
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList4 = new IntArrayList();
            IntArrayList intArrayList5 = new IntArrayList();
            this.A.getNonZeros(intArrayList, intArrayList4, intArrayList5);
            DiagonalIntMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
            DiagonalIntMatrix2DTest.assertEquals((int)2, (int)intArrayList4.size());
            DiagonalIntMatrix2DTest.assertEquals((int)2, (int)intArrayList5.size());
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 3 - this.DINDEX));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 2 - this.DINDEX));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList4.contains(this.NROWS / 3));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList4.contains(this.NROWS / 2));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList5.contains(7));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList5.contains(1));
        }
    }

    public void testGetPositiveValues() {
        this.A.assign(0);
        if (this.DINDEX >= 0) {
            this.A.setQuick(this.NROWS / 3, this.NROWS / 3 + this.DINDEX, 7);
            this.A.setQuick(this.NROWS / 2, this.NROWS / 2 + this.DINDEX, 1);
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList2 = new IntArrayList();
            IntArrayList intArrayList3 = new IntArrayList();
            this.A.getPositiveValues(intArrayList, intArrayList2, intArrayList3);
            DiagonalIntMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
            DiagonalIntMatrix2DTest.assertEquals((int)2, (int)intArrayList2.size());
            DiagonalIntMatrix2DTest.assertEquals((int)2, (int)intArrayList3.size());
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 3));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 2));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 3 + this.DINDEX));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 2 + this.DINDEX));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList3.contains(7));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList3.contains(1));
        } else {
            this.A.setQuick(this.NROWS / 3 - this.DINDEX, this.NROWS / 3, 7);
            this.A.setQuick(this.NROWS / 2 - this.DINDEX, this.NROWS / 2, 1);
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList4 = new IntArrayList();
            IntArrayList intArrayList5 = new IntArrayList();
            this.A.getPositiveValues(intArrayList, intArrayList4, intArrayList5);
            DiagonalIntMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
            DiagonalIntMatrix2DTest.assertEquals((int)2, (int)intArrayList4.size());
            DiagonalIntMatrix2DTest.assertEquals((int)2, (int)intArrayList5.size());
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 3 - this.DINDEX));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 2 - this.DINDEX));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList4.contains(this.NROWS / 3));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList4.contains(this.NROWS / 2));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList5.contains(7));
            DiagonalIntMatrix2DTest.assertTrue((boolean)intArrayList5.contains(1));
        }
    }

    public void testToArray() {
        int[][] nArray = this.A.toArray();
        DiagonalIntMatrix2DTest.assertTrue((this.NROWS == nArray.length ? 1 : 0) != 0);
        for (int i = 0; i < this.NROWS; ++i) {
            DiagonalIntMatrix2DTest.assertTrue((this.NCOLUMNS == nArray[i].length ? 1 : 0) != 0);
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DiagonalIntMatrix2DTest.assertEquals((int)nArray[i][j], (int)this.A.getQuick(i, j));
            }
        }
    }

    public void testVectorize() {
        IntMatrix1D intMatrix1D = this.A.vectorize();
        int n = 0;
        for (int i = 0; i < this.NCOLUMNS; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                DiagonalIntMatrix2DTest.assertEquals((int)this.A.getQuick(j, i), (int)intMatrix1D.getQuick(n++));
            }
        }
    }

    public void testViewColumn() {
        IntMatrix1D intMatrix1D = this.A.viewColumn(this.NCOLUMNS / 2);
        DiagonalIntMatrix2DTest.assertEquals((long)this.NROWS, (long)intMatrix1D.size());
        for (int i = 0; i < this.NROWS; ++i) {
            DiagonalIntMatrix2DTest.assertEquals((int)this.A.getQuick(i, this.NCOLUMNS / 2), (int)intMatrix1D.getQuick(i));
        }
    }

    public void testViewColumnFlip() {
        IntMatrix2D intMatrix2D = this.A.viewColumnFlip();
        DiagonalIntMatrix2DTest.assertEquals((long)this.A.size(), (long)intMatrix2D.size());
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DiagonalIntMatrix2DTest.assertEquals((int)this.A.getQuick(i, this.NCOLUMNS - 1 - j), (int)intMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testViewDice() {
        IntMatrix2D intMatrix2D = this.A.viewDice();
        DiagonalIntMatrix2DTest.assertEquals((int)this.NROWS, (int)intMatrix2D.columns());
        DiagonalIntMatrix2DTest.assertEquals((int)this.NCOLUMNS, (int)intMatrix2D.rows());
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DiagonalIntMatrix2DTest.assertEquals((int)this.A.getQuick(i, j), (int)intMatrix2D.getQuick(j, i));
            }
        }
    }

    public void testViewPart() {
        IntMatrix2D intMatrix2D = this.A.viewPart(this.NROWS / 2, this.NCOLUMNS / 2, this.NROWS / 3, this.NCOLUMNS / 3);
        DiagonalIntMatrix2DTest.assertEquals((int)(this.NROWS / 3), (int)intMatrix2D.rows());
        DiagonalIntMatrix2DTest.assertEquals((int)(this.NCOLUMNS / 3), (int)intMatrix2D.columns());
        for (int i = 0; i < this.NROWS / 3; ++i) {
            for (int j = 0; j < this.NCOLUMNS / 3; ++j) {
                DiagonalIntMatrix2DTest.assertEquals((int)this.A.getQuick(this.NROWS / 2 + i, this.NCOLUMNS / 2 + j), (int)intMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testViewRow() {
        IntMatrix1D intMatrix1D = this.A.viewRow(this.NROWS / 2);
        DiagonalIntMatrix2DTest.assertEquals((long)this.NCOLUMNS, (long)intMatrix1D.size());
        for (int i = 0; i < this.NCOLUMNS; ++i) {
            DiagonalIntMatrix2DTest.assertEquals((int)this.A.getQuick(this.NROWS / 2, i), (int)intMatrix1D.getQuick(i));
        }
    }

    public void testViewRowFlip() {
        IntMatrix2D intMatrix2D = this.A.viewRowFlip();
        DiagonalIntMatrix2DTest.assertEquals((long)this.A.size(), (long)intMatrix2D.size());
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DiagonalIntMatrix2DTest.assertEquals((int)this.A.getQuick(this.NROWS - 1 - i, j), (int)intMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testViewSelectionIntMatrix1DProcedure() {
        this.A.assign(0);
        if (this.DINDEX >= 0) {
            this.A.setQuick(this.NROWS / 4, this.NROWS / 4 + this.DINDEX, 2);
            this.A.setQuick(this.NROWS / 2, this.NROWS / 2 + this.DINDEX, 2);
            IntMatrix2D intMatrix2D = this.A.viewSelection(new IntMatrix1DProcedure(){

                public boolean apply(IntMatrix1D intMatrix1D) {
                    return intMatrix1D.getQuick(DiagonalIntMatrix2DTest.this.NROWS / 4 + DiagonalIntMatrix2DTest.this.DINDEX) == 2;
                }
            });
            DiagonalIntMatrix2DTest.assertEquals((int)1, (int)intMatrix2D.rows());
            DiagonalIntMatrix2DTest.assertEquals((int)this.NCOLUMNS, (int)intMatrix2D.columns());
            DiagonalIntMatrix2DTest.assertEquals((int)this.A.getQuick(this.NROWS / 4, this.NROWS / 4 + this.DINDEX), (int)intMatrix2D.getQuick(0, this.NROWS / 4 + this.DINDEX));
        } else {
            this.A.setQuick(this.NROWS / 4 - this.DINDEX, this.NROWS / 4, 2);
            this.A.setQuick(this.NROWS / 2 - this.DINDEX, this.NROWS / 2, 2);
            IntMatrix2D intMatrix2D = this.A.viewSelection(new IntMatrix1DProcedure(){

                public boolean apply(IntMatrix1D intMatrix1D) {
                    return intMatrix1D.getQuick(DiagonalIntMatrix2DTest.this.NROWS / 4) == 2;
                }
            });
            DiagonalIntMatrix2DTest.assertEquals((int)1, (int)intMatrix2D.rows());
            DiagonalIntMatrix2DTest.assertEquals((int)this.NCOLUMNS, (int)intMatrix2D.columns());
            DiagonalIntMatrix2DTest.assertEquals((int)this.A.getQuick(this.NROWS / 4 - this.DINDEX, this.NROWS / 4), (int)intMatrix2D.getQuick(0, this.NROWS / 4));
        }
    }

    public void testViewSelectionIntArrayIntArray() {
        int[] nArray = new int[]{this.NROWS / 6, this.NROWS / 5, this.NROWS / 4, this.NROWS / 3, this.NROWS / 2};
        int[] nArray2 = new int[]{this.NROWS / 6, this.NROWS / 5, this.NROWS / 4, this.NROWS / 3, this.NROWS / 2, this.NROWS - 1};
        IntMatrix2D intMatrix2D = this.A.viewSelection(nArray, nArray2);
        DiagonalIntMatrix2DTest.assertEquals((int)nArray.length, (int)intMatrix2D.rows());
        DiagonalIntMatrix2DTest.assertEquals((int)nArray2.length, (int)intMatrix2D.columns());
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                DiagonalIntMatrix2DTest.assertEquals((int)this.A.getQuick(nArray[i], nArray2[j]), (int)intMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testViewSorted() {
        IntMatrix2D intMatrix2D = this.A.viewSorted(1);
        for (int i = 0; i < this.NROWS - 1; ++i) {
            DiagonalIntMatrix2DTest.assertTrue((intMatrix2D.getQuick(i + 1, 1) >= intMatrix2D.getQuick(i, 1) ? 1 : 0) != 0);
        }
    }

    public void testViewStrides() {
        int n = 3;
        int n2 = 5;
        IntMatrix2D intMatrix2D = this.A.viewStrides(n, n2);
        for (int i = 0; i < intMatrix2D.rows(); ++i) {
            for (int j = 0; j < intMatrix2D.columns(); ++j) {
                DiagonalIntMatrix2DTest.assertEquals((int)this.A.getQuick(i * n, j * n2), (int)intMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testZMultIntMatrix2DIntMatrix2DIntIntBooleanBoolean() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 3;
        int n6 = 5;
        IntMatrix2D intMatrix2D = new DiagonalIntMatrix2D(this.NROWS, this.NROWS, 0);
        for (int i = 0; i < this.DLENGTH; ++i) {
            intMatrix2D.setQuick(i, i, Math.max(1, this.rand.nextInt() % this.A.rows()));
        }
        int[][] nArray = intMatrix2D.toArray();
        intMatrix2D = this.A.zMult(this.Bt, intMatrix2D, n5, n6, false, false);
        for (n4 = 0; n4 < this.NROWS; ++n4) {
            for (n3 = 0; n3 < this.NROWS; ++n3) {
                n2 = 0;
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    n2 += this.A.getQuick(n3, n) * this.Bt.getQuick(n, n4);
                }
                nArray[n3][n4] = n2 * n5 + nArray[n3][n4] * n6;
            }
        }
        for (n4 = 0; n4 < this.NROWS; ++n4) {
            for (n3 = 0; n3 < this.NROWS; ++n3) {
                DiagonalIntMatrix2DTest.assertEquals((int)nArray[n4][n3], (int)intMatrix2D.getQuick(n4, n3));
            }
        }
        intMatrix2D = null;
        intMatrix2D = this.A.zMult(this.Bt, intMatrix2D, n5, n6, false, false);
        nArray = new int[this.NROWS][this.NROWS];
        for (n4 = 0; n4 < this.NROWS; ++n4) {
            for (n3 = 0; n3 < this.NROWS; ++n3) {
                n2 = 0;
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    n2 += this.A.getQuick(n3, n) * this.Bt.getQuick(n, n4);
                }
                nArray[n3][n4] = n2 * n5;
            }
        }
        for (n4 = 0; n4 < this.NROWS; ++n4) {
            for (n3 = 0; n3 < this.NROWS; ++n3) {
                DiagonalIntMatrix2DTest.assertEquals((int)nArray[n4][n3], (int)intMatrix2D.getQuick(n4, n3));
            }
        }
        intMatrix2D = new DiagonalIntMatrix2D(this.NCOLUMNS, this.NCOLUMNS, 0);
        for (n4 = 0; n4 < this.DLENGTH; ++n4) {
            intMatrix2D.setQuick(n4, n4, Math.max(1, this.rand.nextInt() % this.A.rows()));
        }
        nArray = intMatrix2D.toArray();
        intMatrix2D = this.A.zMult(this.B, intMatrix2D, n5, n6, true, false);
        for (n4 = 0; n4 < this.NCOLUMNS; ++n4) {
            for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
                n2 = 0;
                for (n = 0; n < this.NROWS; ++n) {
                    n2 += this.A.getQuick(n, n3) * this.B.getQuick(n, n4);
                }
                nArray[n3][n4] = n2 * n5 + nArray[n3][n4] * n6;
            }
        }
        for (n4 = 0; n4 < this.NCOLUMNS; ++n4) {
            for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
                DiagonalIntMatrix2DTest.assertEquals((int)nArray[n4][n3], (int)intMatrix2D.getQuick(n4, n3));
            }
        }
        intMatrix2D = null;
        intMatrix2D = this.A.zMult(this.B, intMatrix2D, n5, n6, true, false);
        nArray = new int[this.NCOLUMNS][this.NCOLUMNS];
        for (n4 = 0; n4 < this.NCOLUMNS; ++n4) {
            for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
                n2 = 0;
                for (n = 0; n < this.NROWS; ++n) {
                    n2 += this.A.getQuick(n, n3) * this.B.getQuick(n, n4);
                }
                nArray[n3][n4] = n2 * n5;
            }
        }
        for (n4 = 0; n4 < this.NCOLUMNS; ++n4) {
            for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
                DiagonalIntMatrix2DTest.assertEquals((int)nArray[n4][n3], (int)intMatrix2D.getQuick(n4, n3));
            }
        }
        intMatrix2D = new DiagonalIntMatrix2D(this.NROWS, this.NROWS, 0);
        for (n4 = 0; n4 < this.DLENGTH; ++n4) {
            intMatrix2D.setQuick(n4, n4, Math.max(1, this.rand.nextInt() % this.A.rows()));
        }
        nArray = intMatrix2D.toArray();
        intMatrix2D = this.A.zMult(this.B, intMatrix2D, n5, n6, false, true);
        for (n4 = 0; n4 < this.NROWS; ++n4) {
            for (n3 = 0; n3 < this.NROWS; ++n3) {
                n2 = 0;
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    n2 += this.A.getQuick(n3, n) * this.B.getQuick(n4, n);
                }
                nArray[n3][n4] = n2 * n5 + nArray[n3][n4] * n6;
            }
        }
        for (n4 = 0; n4 < this.NROWS; ++n4) {
            for (n3 = 0; n3 < this.NROWS; ++n3) {
                DiagonalIntMatrix2DTest.assertEquals((int)nArray[n4][n3], (int)intMatrix2D.getQuick(n4, n3));
            }
        }
        intMatrix2D = null;
        intMatrix2D = this.A.zMult(this.B, intMatrix2D, n5, n6, false, true);
        nArray = new int[this.NROWS][this.NROWS];
        for (n4 = 0; n4 < this.NROWS; ++n4) {
            for (n3 = 0; n3 < this.NROWS; ++n3) {
                n2 = 0;
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    n2 += this.A.getQuick(n3, n) * this.B.getQuick(n4, n);
                }
                nArray[n3][n4] = n2 * n5;
            }
        }
        for (n4 = 0; n4 < this.NROWS; ++n4) {
            for (n3 = 0; n3 < this.NROWS; ++n3) {
                DiagonalIntMatrix2DTest.assertEquals((int)nArray[n4][n3], (int)intMatrix2D.getQuick(n4, n3));
            }
        }
        intMatrix2D = new DiagonalIntMatrix2D(this.NCOLUMNS, this.NCOLUMNS, 0);
        for (n4 = 0; n4 < this.DLENGTH; ++n4) {
            intMatrix2D.setQuick(n4, n4, Math.max(1, this.rand.nextInt() % this.A.rows()));
        }
        nArray = intMatrix2D.toArray();
        intMatrix2D = this.A.zMult(this.Bt, intMatrix2D, n5, n6, true, true);
        for (n4 = 0; n4 < this.NCOLUMNS; ++n4) {
            for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
                n2 = 0;
                for (n = 0; n < this.NROWS; ++n) {
                    n2 += this.A.getQuick(n, n3) * this.Bt.getQuick(n4, n);
                }
                nArray[n3][n4] = n2 * n5 + nArray[n3][n4] * n6;
            }
        }
        for (n4 = 0; n4 < this.NCOLUMNS; ++n4) {
            for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
                DiagonalIntMatrix2DTest.assertEquals((int)nArray[n4][n3], (int)intMatrix2D.getQuick(n4, n3));
            }
        }
        intMatrix2D = null;
        intMatrix2D = this.A.zMult(this.Bt, intMatrix2D, n5, n6, true, true);
        nArray = new int[this.NCOLUMNS][this.NCOLUMNS];
        for (n4 = 0; n4 < this.NCOLUMNS; ++n4) {
            for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
                n2 = 0;
                for (n = 0; n < this.NROWS; ++n) {
                    n2 += this.A.getQuick(n, n3) * this.Bt.getQuick(n4, n);
                }
                nArray[n3][n4] = n2 * n5;
            }
        }
        for (n4 = 0; n4 < this.NCOLUMNS; ++n4) {
            for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
                DiagonalIntMatrix2DTest.assertEquals((int)nArray[n4][n3], (int)intMatrix2D.getQuick(n4, n3));
            }
        }
    }
}

