% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psBinomial.R
\name{psBinomial}
\alias{psBinomial}
\title{Smoothing scattered binomial data using P-splines.}
\usage{
psBinomial(
  x,
  y,
  xl = min(x),
  xr = max(x),
  nseg = 10,
  bdeg = 3,
  pord = 2,
  lambda = 1,
  ntrials = 0 * y + 1,
  wts = NULL,
  show = FALSE,
  iter = 100,
  xgrid = 100
)
}
\arguments{
\item{x}{the vector for the continuous regressor of \code{length(y)} and
the abcissae, on which the B-spline basis is constructed.}

\item{y}{the response vector, usually 0/1 or binomial counts.}

\item{xl}{the lower limit for the domain of \code{x} (default is min(\code{x})).}

\item{xr}{the upper limit for the domain of \code{x} (default is max(\code{x})).}

\item{nseg}{the number of evenly spaced segments between xl and xr.}

\item{bdeg}{the number of the degree of the basis, usually 1, 2 (default), or 3.}

\item{pord}{the number of the order of the difference penalty, usually 1, 2, or 3 (defalult).}

\item{lambda}{the (positive) number for the tuning parameter for the penalty.}

\item{ntrials}{the vector for the number of binomial trials (default = 1).}

\item{wts}{the vector of weights, default is 1, zeros allowed.}

\item{show}{Set to TRUE or FALSE to display iteration history.}

\item{iter}{a scalar to set the maximum number of iterations, default \code{iter = 100}.}

\item{xgrid}{a scalar or a vector that gives the \code{x} locations for prediction, useful for plotting.
If a scalar (default 100) is used then a uniform grid of this size along (\code{xl}, \code{xr}).}
}
\value{
\item{pcoef}{a vector of length \code{n} of estimated P-spline coefficients.}
\item{p}{a vector of length \code{m} of estimated probabilities.}
\item{muhat}{a vector of length \code{m} of estimated means (\code{ntrials*p}).}
\item{dev}{deviance}
\item{effdim}{effective dimension of the smooth.}
\item{aic}{AIC}
\item{wts}{a vector of preset weights (default = 1).}
\item{nseg}{the number of B-spline segments.}
\item{bdeg}{the degree of the B-spline basis.}
\item{pord}{the order of the difference penalty.}
\item{family}{the GLM family (repsonse distribution).}
\item{link}{the link function.}
\item{y}{the binomial response.}
\item{x}{the regressor on which the basis is constructed.}
\item{P}{"half" of the penalty matrix, \code{P'P = lambda*D'D}.}
\item{B}{the B-spline basis.}
\item{lambda}{the positive tuning parameter.}
\item{dispersion}{dispersion parameter estimated \code{dev/(m-effdim)}.}
\item{xgrid}{gridded \code{x} values,useful for plotting.}
\item{ygrid}{gridded fitted linear predictor values, useful for plotting.}
\item{pgrid}{gridded (inverse link) fitted probability values, useful for plotting.}
\item{se_eta}{gridded standard errors for the linear predictor.}
}
\description{
\code{psBinomial} is used to smooth scattered
binomial data using P-splines using a logit link function.
}
\examples{
library(JOPS)
# Extract data
library(rpart)
Kyphosis <- kyphosis$Kyphosis
Age <- kyphosis$Age
y <- 1 * (Kyphosis == "present") # make y 0/1
fit1 <- psBinomial(Age, y,
  xl = min(Age), xr = max(Age), nseg = 20,
  bdeg = 3, pord = 2, lambda = 10
)
names(fit1)
plot(fit1, xlab = "Age", ylab = "0/1", se = 2)
}
\references{
Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.

Eilers, P.H.C., Marx, B.D., and Durban, M. (2015).
Twenty years of P-splines, \emph{SORT}, 39(2): 149-186.
}
\author{
Paul Eilers and Brian Marx
}
