% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{modelDiagnostics}
\alias{modelDiagnostics}
\alias{as.modelDiagnostics}
\alias{is.modelDiagnostics}
\alias{modelDiagnostics.lm}
\title{Model Diagnostics Functions}
\usage{
modelDiagnostics(object, ...)

as.modelDiagnostics(x)

is.modelDiagnostics(x)

\method{modelDiagnostics}{lm}(
  object,
  ev.perc = 0.001,
  robust = FALSE,
  distr = "normal",
  standardized = TRUE,
  ...
)
}
\arguments{
\item{object}{A fitted model object, with methods for
\code{model.frame}, \code{resid} and \code{fitted}.}

\item{...}{Additional arguments, passed to methods or  \code{\link{residualDiagnostics}}.}

\item{x}{An object to test or a list to coerce to a
\code{modelDiagnostics} object.}

\item{ev.perc}{A real number between 0 and 1 indicating the
proportion of the theoretical distribution beyond which
values are considered extreme values (possible outliers).
Defaults to .001.}

\item{robust}{Whether to use robust mean and standard deviation estimates
for normal distribution}

\item{distr}{A character string given the assumed distribution.
Passed on to \code{\link{testDistribution}}.
Defaults to \dQuote{normal}.}

\item{standardized}{A logical whether to use standardized residuals.
Defaults to \code{TRUE} generally where possible but may depend on
method.}
}
\value{
A logical (\code{is.modelDiagnostics}) or
  a modelDiagnostics object (list) for
  \code{as.modelDiagnostics} and \code{modelDiagnostics}.
}
\description{
A set of functions to calculate
  model diagnostics on models, including constructors,
  a generic function, a test of whether an object is of the
  \code{modelDiagnostics} class, and methods.
}
\examples{
testm <- stats::lm(mpg ~ hp * factor(cyl), data = mtcars)

md <- modelDiagnostics(testm)
plot(md$residualDiagnostics$testDistribution)
md$extremeValues

plot(md)

md <- modelDiagnostics(testm, ev.perc = .1)
md$extremeValues
plot(md, ncol = 2)

testdat <- data.frame(
  y = c(1, 2, 2, 3, 3, NA, 9000000, 2, 2, 1),
  x = c(1, 2, 3, 4, 5, 6, 5, 4, 3, 2))

modelDiagnostics(
  lm(y ~ x, data = testdat, na.action = "na.omit"),
  ev.perc = .1)$extremeValues

modelDiagnostics(
  lm(y ~ x, data = testdat, na.action = "na.exclude"),
  ev.perc = .1)$extremeValues

## clean up
rm(testm, md, testdat)
}
