\name{cfderiv}
\alias{cfderiv}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Auto-constructing Frechet derivative of D-criterion based on general equivalence theorem 
%Auto-constructing derivative function of D-criterion
}
\description{

Auto-constructs Frechet derivative of D-criterion at \eqn{M(\xi, \beta)} and in direction \eqn{M(\xi_x, \beta)} where \eqn{M} is Fisher information matrix, \eqn{\beta} is vector of parameters, \eqn{\xi} is the interested design and \eqn{\xi_x} is a unique design which has only a point \eqn{x}. The constructed Frechet derivative is an \R function with argument \eqn{x}.

%Auto-constructs derivative function of D-criterion based on general equivalence theorem (Kiefer, 1974).  

%models that their response variables are independent and can be writen as a function of explanatory variables and parameters. This function must be continuous and differentiable with respect to the models parameters. In addition, distribution of response variable must belong to the Natural exponential family. See 'Note' for more details. 
}
\usage{
cfderiv(ymean, yvar, param, points, weights)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
\item{ymean}{ a character string, 
formula of \eqn{E(y)} with specific satndard: characters \code{b1}, \code{b2}, \code{b3}, \dots symbolize model parameters and \code{x1}, \code{x2}, \code{x3}, \dots symbolize explanatory variables. See 'Examples'.
}
  \item{yvar}{
a character string, formula of \eqn{Var(y)} with specific standard as \code{ymean}. See 'Details' and 'Examples'.
}
  \item{param}{
a vector of values of parameters which must correspond to \code{b1}, \code{b2}, \code{b3}, \dots  in \code{ymean}.
%, its length must be equal to the number of b1, b2, ... in 'ymean'.
}
  \item{points}{
a vector of points which belong to design \eqn{\xi} . See 'Details'.
}
  \item{weights}{
a vector of \eqn{\xi} points weights. The sum of weights should be \eqn{1}; otherwise they will be normalized.
}
}
\details{
If response variables have the same constant variance, for example \eqn{\sigma^2}, then \code{yvar} must be \eqn{1}.  


Consider design \eqn{\xi} with \eqn{n} \eqn{m}-dimensional points. Then, the vector of \eqn{\xi} points is 
\deqn{(x_1, x_2, \ldots, x_i, \ldots, x_n),}
where \eqn{x_i = (x_{i1}, x_{i2}, \ldots, x_{im})}. Hence the length of vector points is \eqn{mn}.
}
\value{
%%  ~Describe the value returned
%%  If it is a LIST, use
%\item{comp1 }{Description of 'comp1'}
\item{fderiv}{ a function in which its argument is a vector \eqn{x}, an \eqn{m}-dimentional design point, and its output is the value of Frechet derivative at \eqn{M(\xi, \beta)} and in direction \eqn{M(\xi_x, \beta)}.
}
%% ...
}
\references{
Masoudi, E., Sarmad, M. and Talebi, H. 2012, An Almost General Code in R to Find Optimal Design, In Proceedings of the 1st ISM International Statistical Conference 2012, 292-297.

Kiefer, J. C.  1974, General equivalence theory for optimum designs (approximate theory), Ann. Statist., 2, 849-879.7.
}
\author{
Ehsan Masoudi, Majid Sarmad and Hooshang Talebi
}
\note{
A design \eqn{\xi} is D-optimal if and only if Frechet derivative at \eqn{M(\xi, \beta)} and in direction \eqn{M(\xi_x, \beta)}is greater than or equal to \eqn{0} on the design space. The equality must be achieved just at \eqn{\xi} points. Here, \eqn{x} is an arbitrary point on design space.

This function is applicable for models that can be written as \eqn{E(Y_i) = f(x_i,\beta)}
where \eqn{y_i} is the \eqn{ith} response variable, \eqn{x_i} is the observation vector of the \eqn{ith} explanatory variables, \eqn{\beta} is the vector of parameters and \eqn{f} is a continuous and differentiable function with respect to \eqn{\beta}.
In addition, response variables must be independent with distributions that belong to the Natural exponential family. Logistic,Poisson, Negative Binomial, Exponential,  Richards, Weibull, Log-linear, Inverse Quadratic and Michaelis-Menten are examples of these models.
}


\examples{
## Logistic dose response model:
ymean <- "(1/(exp(-b2 * (x1 - b1)) + 1))"
yvar <- "(1/(exp(-b2 * (x1 - b1)) + 1))*(1 - (1/(exp(-b2 * (x1 - b1)) + 1)))"
func <- cfderiv(ymean, yvar, param =  c(.9, .8), points = c(-1.029256, 2.829256),
 weights = c(.5, .5))
## plot func on the design interval to verify the optimality of the given design
x <- seq(-5, 5, by = .1)
plot(x, -func(x), type = "l")

## Inverse Quadratic model
ymean <- "x1/(b1 + b2 * x1 + b3 * (x1)^2)"
yvar <- "1"
func <- cfderiv(ymean, yvar, param = c(17, 15, 9), points = c(0.33, 1.37, 5.62), 
weights = rep(.33, 3))
## plot func on the design interval to verify the optimality of the given design
x <- seq(0, 15, by = .1)
plot(x, -func(x), type = "l")

#####################################################################
## In the following, ymean and yvar for some famous models are given:

## Inverse Quadratic model (another form):
ymean <- "(b1 * x1)/(b2 + x1 + b3 * (x1)^2)"
yvar <- "1"

## Logistic dose response model:
ymean <- "(1/(exp(-b2 * (x1 - b1)) + 1))"
yvar <- "(1/(exp(-b2 * (x1 - b1)) + 1)) * (1 - (1/(exp(-b2 * (x1 - b1)) + 1)))"

## Logistic model:
ymean <- "1/(exp(-b1 - b2 * x1) + 1)"
yvar <- "(1/(exp(-b1 - b2 * x1) + 1)) * (1 - (1/(exp(-b1 - b2 * x1) + 1)))"

## Poisson model:
ymean <- yvar <-  "exp(b1 + b2 * x1)"

## Poisson dose response model:
ymean <- yvar <- "b1 * exp(-b2 * x1)"

## Weibull model:
ymean <- "b1 - b2 * exp(-b3 * x1^b4)"
yvar <- "1"

## Richards model:
ymean <- "b1/(1 + b2 * exp(-b3 * x1))^b4"
yvar <- "1"

## Michaelis-Menten model:
ymean <- "(b1 * x1)/(1 + b2 * x1)"
yvar <- "1"
#
ymean <- "(b1 * x1)/(b2 + x1)"
yvar <= "1"
#
ymean <- "x1/(b1 + b2 * x1)"
yvar <- "1"

## log-linear model:
ymean <- "b1 + b2 * log(x1 + b3)"
yvar <- "1"

## Exponential model:
ymean <- "b1 + b2 * exp(x1/b3)"
yvar <- "1"

## Emax model:
ymean  <- "b1 + (b2 * x1)/(x1 + b3)"
yvar <- "1"

## Negative binomial model Y ~ NB(E(Y), theta) where E(Y) = b1*exp(-b2*x1):
theta = 5
ymean <- "b1 * exp(-b2 * x1)"
yvar <- paste ("b1 * exp(-b2 * x1) * (1 + (1/", theta, ") * b1 * exp(-b2 * x1))" , sep = "")

## Linear regression model:
ymean <- "b1 + b2 * x1 + b3 * x2 + b4 * x1 * x2"
yvar = "1"
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{optimal design}
\keyword{equivalence theorem}% __ONLY ONE__ keyword per line
