% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_STEP_RPC.R
\name{stepRPC}
\alias{stepRPC}
\title{Stepwise (OLS & fractional logistic) regression based on risk profile concept}
\usage{
stepRPC(
  start.model,
  risk.profile,
  p.value = 0.05,
  db,
  reg.type = "ols",
  check.start.model = TRUE,
  offset.vals = NULL
)
}
\arguments{
\item{start.model}{Formula class that represents the starting model. It can include some risk factors, but it can be
defined only with intercept (\code{y ~ 1} where \code{y} is target variable).}

\item{risk.profile}{Data frame with defined risk profile. It has to contain the following columns: \code{rf} and
\code{group}. Column \code{group} defines order of groups that will be tested first as a candidate
for the regression model. Risk factors selected in each group are kept as a starting variables
for the next group testing. Column \code{rf} contains all candidate risk factors supplied for testing.}

\item{p.value}{Significance level of p-value of the estimated coefficients. For \code{WoE} coding this value is
is directly compared to the p-value of the estimated coefficients, while for \code{dummy} coding
multiple Wald test is employed and its value is used for comparison with selected threshold (\code{p.value}).}

\item{db}{Modeling data with risk factors and target variable. All risk factors (apart from the risk factors from the starting model)
should be categorized and as of character type.}

\item{reg.type}{Regression type. Available options are: \code{"ols"} for OLS regression and \code{"frac.logit"} for
fractional logistic regression. Default is \code{"ols"}. For \code{"frac.logit"} option, target has to have
all values between 0 and 1.}

\item{check.start.model}{Logical (\code{TRUE} or \code{FALSE}), if risk factors from the starting model should
checked for p-value and trend in stepwise process.}

\item{offset.vals}{This can be used to specify an a priori known component to be included in the linear predictor during fitting.
This should be \code{NULL} or a numeric vector of length equal to the number of cases. Default is \code{NULL}.}
}
\value{
The command \code{stepRPC} returns a list of four objects.\cr
The first object (\code{model}), is the final model, an object of class inheriting from \code{"glm"}.\cr
The second object (\code{steps}), is the data frame with risk factors selected at each iteration.\cr
The third object (\code{warnings}), is the data frame with warnings if any observed.
The warnings refer to the following checks: if risk factor has more than 10 modalities or
if any of the bins (groups) has less than 5\% of observations.\cr
The final, fourth, object \code{dev.db} returns the model development database.
}
\description{
\code{stepRPC} customized stepwise regression with p-value and trend check which additionally takes into account
the order of supplied risk factors per group when selects a candidate for the final regression model. Trend check is performed
comparing observed trend between target and analyzed risk factor and trend of the estimated coefficients within the
OLS regression. Note that procedure checks the column names of supplied \code{db} data frame therefore some
renaming (replacement of special characters) is possible to happen. For details, please, check the help example.
}
\examples{
library(monobin)
library(LGDtoolkit)
data(lgd.ds.c)
num.rf <- sapply(lgd.ds.c, is.numeric)
num.rf <- names(num.rf)[!names(num.rf)\%in\%"lgd" & num.rf]
num.rf
for	(i in 1:length(num.rf)) {
num.rf.l <- num.rf[i]
lgd.ds.c[, num.rf.l] <- sts.bin(x = lgd.ds.c[, num.rf.l], y = lgd.ds.c[, "lgd"])[[2]]	
}
str(lgd.ds.c)
#define risk factor groups
set.seed(123)
rf.pg <- data.frame(rf = names(lgd.ds.c)[!names(lgd.ds.c)\%in\%"lgd"], 
		  group = sample(1:5, ncol(lgd.ds.c) - 1, rep = TRUE))
rf.pg <- rf.pg[order(rf.pg$group, rf.pg$r), ]
rf.pg
res <- LGDtoolkit::stepRPC(start.model = lgd ~ 1, 
	   risk.profile = rf.pg, 
	   p.value = 0.05, 
	   db = lgd.ds.c,
	   reg.type = "ols")
names(res)
summary(res$model)$coefficients
summary(res$model)$r.squared
}
