% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_weather_agent.R
\name{build_weather_agent}
\alias{build_weather_agent}
\title{Build a Weather Agent}
\arguments{
\item{llm}{A function that accepts a character prompt and returns an LLM response.}

\item{location_query}{Free-text location query (e.g., "weather in Toronto").}

\item{system_prompt}{Optional LLM system prompt for weather reporting.}

\item{weather_api_key}{OpenWeatherMap API key (defaults to OPENWEATHERMAP_API_KEY env var).}

\item{units}{Unit system ("metric" or "imperial").}

\item{n_tries}{Number of retry attempts for API/LLM calls (default: 3).}

\item{backoff}{Base seconds to wait between retries (default: 2).}

\item{endpoint_url}{OpenWeatherMap endpoint URL.}

\item{verbose}{Logical controlling progress messages (default: TRUE).}
}
\value{
A list containing:
\itemize{
  \item success - Logical indicating if operation succeeded
  \item location - Cleaned location string
  \item weather_raw - Raw API response
  \item weather_formatted - Formatted weather string
  \item llm_response - Generated weather report
  \item timestamp - Time of response
  \item cache_hit - Logical indicating cache usage
  \item attempts - Number of tries made
}
}
\description{
Constructs an LLM-powered weather assistant that fetches data from OpenWeatherMap
and generates user-friendly reports. Handles location parsing, API calls, caching,
and LLM-based summarization.
}
\examples{
\dontrun{
# Get weather information
weather_agent <- build_weather_agent(
  llm = my_llm_wrapper,
  location_query = "Tokyo, Japan",
  system_prompt = NULL,
  weather_api_key = NULL,
  units = "metric", # metric or imperial
  n_tries = 3,
  backoff = 2,
  endpoint_url = NULL,
  verbose = FALSE
)
}
}
