% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LPtest.R
\name{LPtest}
\alias{LPtest}
\title{Testing for a Pareto tail}
\usage{
LPtest(x, n, muNull, sigmaNull, minRank)
}
\arguments{
\item{x}{list: sequence of integers 1,...,K, where K is the mumber of datasets. Set x = 1 in case
of a single dataset.}

\item{n}{sample size.}

\item{muNull}{lognormal expected value under the null hypothesis.}

\item{sigmaNull}{lognormal standard deviation under the null hypothesis.}

\item{minRank}{minimum possible rank of the threshold.}
}
\value{
A list with the following elements:

LR: observed value of the llr test.
}
\description{
This function draws a bootstrap sample from the null (lognormal) distribution and computes the test for the null hypothesis of
a pure lognormal distribution versus the alternative of a lognormal-Pareto
mixture. To be only called from ParallelTest.
}
\examples{
n = 100
muNull = mean(log(TN2016))
sigmaNull = sd(log(TN2016))
minRank = 90
res = LPtest(1,n,muNull,sigmaNull,minRank)
}
\references{
{
\insertRef{bee22}{LNPar}
}
}
\keyword{likelihood;}
\keyword{log-likelihood}
\keyword{mixture;}
\keyword{profile}
\keyword{ratio}
\keyword{test.}
