% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Trans_to_phylo.R
\name{Trans_to_phylo}
\alias{Trans_to_phylo}
\title{Convert a LorMe object to a phyloseq object}
\usage{
Trans_to_phylo(taxobj, use_reads = TRUE)
}
\arguments{
\item{taxobj}{A \code{\link{LorMe}} object (usually generated by \code{tax_summary}).}

\item{use_reads}{Logical. \code{FALSE} (default) uses \strong{relative abundance} (\code{Base_percent}); \code{TRUE} uses \strong{raw counts}
(\code{Base}).}
}
\value{
A \code{\link[phyloseq:phyloseq]{phyloseq}} object  containing
\code{otu_table}, \code{sample_data}, \code{tax_table} and optionally
\code{phy_tree} (only if \code{taxobj} has a tree).
}
\description{
Convert a LorMe object to a phyloseq object
}
\examples{
\dontrun{
data("Two_group")

Two_group_phylo=Trans_to_phylo(taxobj = Two_group,use_reads = F)

plot_bar(Two_group_phylo,fill="Phylum") #Just to show it can be used for analysis
}
}
