% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_02_COMPUTE_PSI_5_Compute_RI.R
\name{ComputePSI.RI}
\alias{ComputePSI.RI}
\title{Compute Retained-intron (RI) Percent Spliced-in (PSI) Values}
\usage{
ComputePSI.RI(MarvelObject, CoverageThreshold, IntronCounts, thread)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CreateMarvelObject} function.}

\item{CoverageThreshold}{Numeric value. Coverage threshold below which the PSI of the splicing event will be censored, i.e. annotated as missing (NA). Coverage defined as the total number of reads supporting both included and excluded isoforms.}

\item{IntronCounts}{Data frame. Columns indicate sample IDs, rows indicate intron coordinates, and values indicate total intron coverage. The first column needs to be named \code{coord.intron}. These values will be combined with splice junction counts in the MARVEL object to compute PSI values.}

\item{thread}{Numeric value. Set number of threads.}
}
\value{
An object of class S3 containing all the original slots as inputted by the user in addition to two new slots. \code{$SpliceFeatureValidated$RI} contains the validated splicing event metadata. \code{$PSI$RI} contains the computed PSI values for the validated splicing events.
}
\description{
\code{ComputePSI.RI} computes percent spliced-in (PSI) retained intron (RI) splicing event.
}
\details{
This function computes the PSI for each RI splicing event. Splicing events provided in \code{SpliceFeature} data frame will first be cross-checked against the splice junctions provided in \code{SpliceJunction} data frame. Only events whose junctions are found in \code{SpliceJunction} are retained. Formula for computing PSI is the normalized intron coverage divided by the total number of reads supporting both included and excluded isoforms. Normalized intron coverage is computed by taking the total coverage over the intronic region adjusted (divided) by the intron length.
}
\examples{
# Load input
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

# Run example
marvel <- ComputePSI.RI(MarvelObject=marvel,
                        CoverageThreshold=10,
                        IntronCounts=marvel$IntronCounts,
                        thread=1
                        )
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
