% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Network-Parameters.R
\name{parameterizeMGDrivE}
\alias{parameterizeMGDrivE}
\title{parameterizeMGDrivE}
\usage{
parameterizeMGDrivE(
  runID = 1L,
  nPatch,
  simTime,
  sampTime = 1L,
  tEgg = 1L,
  tLarva = 14L,
  tPupa = 1L,
  beta = 32,
  muAd = 0.123,
  popGrowth = 1.096,
  AdPopEQ,
  LarPopRatio,
  AdPopRatio_F,
  AdPopRatio_M,
  inheritanceCube
)
}
\arguments{
\item{runID}{Begin counting runs with this set of parameters from this value}

\item{nPatch}{Number of \code{\link{Patch}}}

\item{simTime}{Maximum time to run simulation}

\item{sampTime}{Times to sample, used as tNow \%\% sampTime, default is every day}

\item{tEgg}{Length of egg stage}

\item{tLarva}{Length of larval instar stage}

\item{tPupa}{Length of pupal stage}

\item{beta}{Female egg batch size of wild-type}

\item{muAd}{Wild-type daily adult mortality (1/muAd is average wild-type lifespan)}

\item{popGrowth}{Daily population growth rate (used to calculate equilibrium)}

\item{AdPopEQ}{Single number or vector of adult population size at equilibrium
(single number implies all patches have the same population)}

\item{LarPopRatio}{May be empty; if not, a vector gives the wildtype gene frequencies
among larval stages at the beginning of simulation or a matrix provides different
initial frequencies for each patch (every row is a different patch, must have nrow = nPatch)}

\item{AdPopRatio_F}{May be empty; if not, a vector gives the wildtype gene frequencies
among adult females at the beginning of simulation or a matrix provides different
initial frequencies for each patch (every row is a different patch, must have nrow = nPatch)}

\item{AdPopRatio_M}{May be empty; if not, a vector gives the wildtype gene frequencies
among adult males at the beginning of simulation or a matrix provides different
initial frequencies for each patch (every row is a different patch, must have nrow = nPatch)}

\item{inheritanceCube}{Inheritance cube to check/set population ratios at the beginning of the simulation}
}
\description{
Generate parameters for simulation on a \code{\link{Network}}.
Parameters include: average generation time \eqn{g}, population growth rate \eqn{R_{m}},
aquatic mortality \eqn{\mu_{Aq}}, and aquatic survival \eqn{\theta_{Aq}}, which
are shared between patches and calculated by \code{\link{calcAverageGenerationTime}},
\code{\link{calcPopulationGrowthRate}}, and \code{\link{calcLarvalStageMortalityRate}}. \cr
Patch-specific parameters \eqn{\alpha} and \eqn{L_{eq}}
are calculated for each patch by \code{\link{calcDensityDependentDeathRate}}
and \code{\link{calcLarvalPopEquilibrium}}.
}
\examples{
# using default parameters for 2 patches
#  using different population sizes for patches
simPars <- parameterizeMGDrivE(nPatch = 2, simTime = 365,
                               AdPopEQ = c(100,200), inheritanceCube = cubeMendelian())

}
