% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParallelTable.R
\name{quartetTableParallel}
\alias{quartetTableParallel}
\title{Produce table of counts of quartets displayed on trees, in parallel for large data sets}
\usage{
quartetTableParallel(
  trees,
  taxonnames = NULL,
  epsilon = 0,
  random = 0,
  numCores
)
}
\arguments{
\item{trees}{multiphylo object containing un/rooted metric/topological trees}

\item{taxonnames}{vector of \code{n} names of taxa of interest; if \code{NULL} then taken from taxa on \code{trees[[1]]}}

\item{epsilon}{minimum for branch lengths to be treated as non-zero}

\item{random}{number of random subsets of 4 taxa to consider; if 0, use all \code{n} choose 4 subsets}

\item{numCores}{number of cores to use for parallel calls}
}
\value{
an (\code{n} choose 4)x(\code{n}+4) matrix (or (\code{random})x(\code{n}+4) matrix) encoding
    4 taxon subsets of \code{taxonnames} and counts of each of the
    quartets 12|34, 13|24, 14|23, 1234 across the trees
}
\description{
Compiles table of quartet count concordance factors (qcCFs) for topological quartets displayed on a
collection of trees. Gives the same output as \code{quartetTable}, but operates in parallel.
}
\details{
The number of available cores can be determined by \code{parallel::detectCores()}.  
With overhead, tabulating quartets for a large data set (many taxa and/or many gene trees) on a 4-core 
computer using \code{numCores=4} may require less than half the elapsed time of the sequential \code{quartetTable}.

The names in \code{taxonnames} may be any subset of those on the trees.
Branch lengths of non-negative size less than or equal to \code{epsilon}
are treated as zero, giving polytomies.

In the returned table, columns are labeled by taxon names and quartet names ("12|34", etc.).
1s and 0s in taxon columns indicate the taxa in a quartet. Quartet 12|34
means the first and second indicated taxa form a cherry, 13|24 means the first and third form a cherry, 14|23 means
the first and fourth form a cherry, and 1234 means the quartet is unresolved.

An error occurs if any branch length is negative.
Warnings are given if some of \code{taxonnames} are missing on some trees, or
if some 4-taxon set is not on any tree.

If \code{random}>0, then for efficiency \code{random} should be much smaller then
the number of possible 4 taxon subsets.

If the quartet counts are to be used for NANUQ, or any other routines requiring resolved quartet counts,
\code{\link{quartetTableResolved}} must be run following \code{quartetTableParallel}. See example below.
}
\examples{
\donttest{
gtrees=read.tree(file=system.file("extdata","dataHeliconiusMartin",package="MSCquartets"))
N <- parallel::detectCores()
QT=quartetTableParallel(gtrees,numCores=N)
RQT=quartetTableResolved(QT)
pTable=NANUQ(RQT,alpha=1e-40, beta=1e-30, outfile = file.path(tempdir(), "NANUQdist"))}

}
\seealso{
\code{\link{quartetTable}}, \code{\link{quartetTableResolved}}, \code{\link{quartetTableDominant}}, \code{\link{taxonNames}}
}
